/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.qpid;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.messagebox.internal.qpid.MessageLockException;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManager;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManagerException;

public class MessageLock {
    private static final Log log = LogFactory.getLog(MessageLock.class);
    private static final long MAX_VISIBILITY_TIMEOUT = 43200000L;
    private QueueConnection jmsConnection = null;
    private QueueSession jmsSession = null;
    private Message jmsMessage = null;
    private String receiptHandle = null;
    private ConcurrentHashMap lockStore = null;
    private Timer visibilityTimer = null;
    private long visibilityTimeout = 0L;
    private Date invisibleUntil = null;
    private String messageBoxID = null;
    private boolean lockReleased = false;
    private Scheduler scheduler;

    public MessageLock(QueueConnection jmsConnection, QueueSession jmsSession, Message jmsMessage, long visibilityTimeout) throws MessageLockException {
        this.jmsConnection = jmsConnection;
        this.jmsSession = jmsSession;
        this.jmsMessage = jmsMessage;
        this.receiptHandle = UUID.randomUUID().toString();
        this.visibilityTimeout = visibilityTimeout;
        this.scheduler = new Scheduler();
        this.invisibleUntil = new Date(System.currentTimeMillis() + visibilityTimeout);
        this.startVisibilityTimer();
    }

    public synchronized void changeMessageVisibility(long extension) throws MessageLockException {
        if (this.visibilityTimeout + extension > 43200000L) {
            throw new MessageLockException("Trying to exceed the maximum permitted visibility timeout");
        }
        this.visibilityTimeout += extension;
        this.extendVisibilityTimer(extension);
    }

    public synchronized void deleteMessage() throws MessageLockException {
        try {
            if (!this.lockReleased) {
                this.jmsMessage.acknowledge();
                this.unlock();
            }
        }
        catch (JMSException e) {
            throw new MessageLockException("Error while deleting message : " + e.getMessage(), e);
        }
    }

    private synchronized void unlock() throws MessageLockException {
        try {
            if (!this.lockReleased) {
                this.jmsSession.close();
                QueueConnectionManager.getInstance().releaseConnection(this.jmsConnection);
                this.lockStore.remove(this.receiptHandle);
                this.lockReleased = true;
            }
        }
        catch (JMSException e) {
            throw new MessageLockException("Error while unlocking message : " + e.getMessage(), e);
        }
        catch (QueueConnectionManagerException e) {
            throw new MessageLockException("Error while unlocking message : " + e.getMessage(), e);
        }
    }

    private void startVisibilityTimer() {
        this.visibilityTimer = new Timer();
        this.visibilityTimer.schedule((TimerTask)this.scheduler, this.visibilityTimeout);
    }

    private synchronized void extendVisibilityTimer(long extension) {
        if (!this.lockReleased) {
            this.invisibleUntil.setTime(this.invisibleUntil.getTime() + extension);
            this.scheduler.setTaskCanceled(true);
            this.visibilityTimer = new Timer();
            this.scheduler = new Scheduler();
            this.visibilityTimer.schedule((TimerTask)this.scheduler, this.invisibleUntil);
        }
    }

    public String getMessageBoxID() {
        return this.messageBoxID;
    }

    public void setMessageBoxID(String messageBoxID) {
        this.messageBoxID = messageBoxID;
    }

    public Message getJmsMessage() {
        return this.jmsMessage;
    }

    public void setLockStore(ConcurrentHashMap lockStore) {
        this.lockStore = lockStore;
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public long getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    private class Scheduler
    extends TimerTask {
        private boolean taskCanceled = false;

        private Scheduler() {
        }

        @Override
        public void run() {
            if (!this.taskCanceled) {
                try {
                    MessageLock.this.unlock();
                }
                catch (MessageLockException e) {
                    log.error((Object)"Failed to unlock the message", (Throwable)e);
                }
            }
        }

        public void setTaskCanceled(boolean taskCanceled) {
            this.taskCanceled = taskCanceled;
        }
    }
}

