/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.qpid;

import java.net.SocketException;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.event.client.stub.generated.authentication.AuthenticationAdminServiceStub;
import org.wso2.carbon.event.client.stub.generated.authentication.AuthenticationExceptionException;
import org.wso2.carbon.messagebox.MessageBoxConfigurationException;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.MessageBoxService;
import org.wso2.carbon.messagebox.MessageBoxServiceFactory;
import org.wso2.carbon.messagebox.internal.ds.MessageBoxServiceValueHolder;
import org.wso2.carbon.messagebox.internal.qpid.JMSMessageBoxService;
import org.wso2.carbon.messagebox.internal.qpid.MessageBoxAuthorizationHandler;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManager;
import org.wso2.carbon.messagebox.internal.qpid.RegistryMessageBoxHandler;
import org.wso2.carbon.messagebox.internal.registry.RegistryQueueManager;
import org.wso2.carbon.qpid.stub.service.QpidAdminServiceStub;
import org.wso2.carbon.utils.NetworkUtils;

public class JMSMessageBoxServiceFactory
implements MessageBoxServiceFactory {
    public static final String MB_REMOTE_MESSGE_BROKER = "remoteMessageBroker";
    public static final String MB_HOST_NAME = "hostName";
    public static final String MB_SERVICE_PORT = "servicePort";
    public static final String MB_USER_NAME = "userName";
    public static final String MB_PASSWORD = "password";
    public static final String MB_QPID_PORT = "qpidPort";
    public static final String MB_CLIENT_ID = "clientID";
    public static final String MB_VIRTUAL_HOST_NAME = "virtualHostName";
    public static final String MB_TYPE = "type";
    public static final String MB_WEB_CONTEXT = "webContext";

    public void setQueueConnectionManager(OMElement config) throws MessageBoxConfigurationException {
        String type = config.getAttributeValue(new QName(null, MB_TYPE));
        QueueConnectionManager queueConnectionManager = QueueConnectionManager.getInstance();
        queueConnectionManager.setType(type);
        if ("remote".equals(type)) {
            OMElement remoteQpidAdminService = config.getFirstChildWithName(new QName("http://wso2.org/carbon/messagebox/", MB_REMOTE_MESSGE_BROKER));
            String hostName = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_HOST_NAME);
            String servicePort = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_SERVICE_PORT);
            String userName = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_USER_NAME);
            String password = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_PASSWORD);
            String qpidPort = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_QPID_PORT);
            String clientID = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_CLIENT_ID);
            String virtualHostName = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_VIRTUAL_HOST_NAME);
            String webContext = JMSMessageBoxServiceFactory.getValue(remoteQpidAdminService, MB_WEB_CONTEXT);
            if (!webContext.trim().endsWith("/")) {
                webContext = webContext + "/";
            }
            ConfigurationContext clientConfigurationContext = MessageBoxServiceValueHolder.getInstance().getConfigurationContextService().getClientConfigContext();
            try {
                String servicesString = "https://" + hostName + ":" + servicePort + webContext + "services/";
                AuthenticationAdminServiceStub stub = new AuthenticationAdminServiceStub(clientConfigurationContext, servicesString + "AuthenticationAdmin");
                stub._getServiceClient().getOptions().setManageSession(true);
                boolean isAuthenticated = stub.login(userName, password, NetworkUtils.getLocalHostname());
                if (!isAuthenticated) {
                    throw new MessageBoxConfigurationException("Can not authenticate to the remote messge broker ");
                }
                ServiceContext serviceContext = stub._getServiceClient().getLastOperationContext().getServiceContext();
                String sessionCookie = (String)serviceContext.getProperty("Cookie");
                QpidAdminServiceStub qpidAdminServiceStub = new QpidAdminServiceStub(clientConfigurationContext, servicesString + "QpidAdminService");
                qpidAdminServiceStub._getServiceClient().getOptions().setManageSession(true);
                qpidAdminServiceStub._getServiceClient().getOptions().setProperty("Cookie", (Object)sessionCookie);
                String accessKey = qpidAdminServiceStub.getAccessKey();
                queueConnectionManager.setHostName(hostName);
                queueConnectionManager.setAccessKey(accessKey);
                queueConnectionManager.setQpidPort(qpidPort);
                queueConnectionManager.setClientID(clientID);
                queueConnectionManager.setVirtualHostName(virtualHostName);
            }
            catch (AxisFault axisFault) {
                throw new MessageBoxConfigurationException("Can not connect to the remote Qpid Service ", axisFault);
            }
            catch (SocketException e) {
                throw new MessageBoxConfigurationException("Can not connect to the remote Qpid Service ", e);
            }
            catch (AuthenticationExceptionException e) {
                throw new MessageBoxConfigurationException("Can not connect to the remote Qpid Service ", e);
            }
            catch (RemoteException e) {
                throw new MessageBoxConfigurationException("Can not connect to the remote Qpid Service ", e);
            }
        }
    }

    public static String getValue(OMElement omElement, String localPart) {
        OMElement childElement = omElement.getFirstChildWithName(new QName(omElement.getNamespace().getNamespaceURI(), localPart));
        return childElement.getText();
    }

    @Override
    public MessageBoxService getMessageBoxService(OMElement config) throws MessageBoxConfigurationException {
        try {
            JMSMessageBoxService messageBoxService = new JMSMessageBoxService();
            messageBoxService.setQueueManager(new RegistryQueueManager());
            messageBoxService.setRegistryMessageBoxHandler(new RegistryMessageBoxHandler());
            messageBoxService.setAuthorizationHandler(new MessageBoxAuthorizationHandler());
            this.setQueueConnectionManager(config);
            return messageBoxService;
        }
        catch (MessageBoxException e) {
            throw new MessageBoxConfigurationException("Failed to instantiate JMSMessageBoxService class.", e);
        }
    }
}

