/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.inmemory;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.messagebox.MessageBoxDetails;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.MessageBoxService;
import org.wso2.carbon.messagebox.MessageDetails;
import org.wso2.carbon.messagebox.PermissionLabel;
import org.wso2.carbon.messagebox.SQSMessage;
import org.wso2.carbon.messagebox.internal.inmemory.MessageBox;
import org.wso2.carbon.messagebox.queue.QueueManager;

public class InMemoryMessageBoxService
implements MessageBoxService {
    private static final Log log = LogFactory.getLog(InMemoryMessageBoxService.class);
    private ConcurrentHashMap<String, MessageBox> messageBoxStore = new ConcurrentHashMap();

    @Override
    public String createMessageBox(String messageBoxName, long defaultVisibilityTimeout) throws MessageBoxException {
        if (this.messageBoxStore.contains(messageBoxName)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxName + " already exists"));
            }
            if (this.messageBoxStore.get(messageBoxName).getMessageBoxDetails().getDefaultVisibilityTimeout() != defaultVisibilityTimeout) {
                throw new MessageBoxException("Queue already exists", "AWS.SimpleQueueService.QueueNameExists ");
            }
        } else {
            String messageBoxOwner = messageBoxName.split(File.separator)[0];
            if (this.isAdminLoggedIn() || this.getLoggedInUser().equals(messageBoxOwner)) {
                MessageBox messageBox = new MessageBox(messageBoxOwner, messageBoxName, defaultVisibilityTimeout);
                this.messageBoxStore.put(messageBoxName, messageBox);
            } else {
                throw new MessageBoxException(this.getLoggedInUser() + " has no permission to create message box for user " + messageBoxOwner);
            }
        }
        return messageBoxName;
    }

    @Override
    public MessageBoxDetails[] getAllMessageBoxes() throws MessageBoxException {
        ArrayList<MessageBoxDetails> arrayList = new ArrayList<MessageBoxDetails>();
        if (this.isAdminLoggedIn()) {
            for (String messageBoxName : this.messageBoxStore.keySet()) {
                MessageBox messageBox = this.messageBoxStore.get(messageBoxName);
                arrayList.add(messageBox.getMessageBoxDetails());
            }
        } else {
            String loggedInUser = this.getLoggedInUser();
            for (String messageBoxName : this.messageBoxStore.keySet()) {
                if (!messageBoxName.split(File.separator)[0].equals(loggedInUser)) continue;
                MessageBox messageBox = this.messageBoxStore.get(messageBoxName);
                arrayList.add(messageBox.getMessageBoxDetails());
            }
        }
        MessageBoxDetails[] messageBoxDetailsArray = arrayList.toArray(new MessageBoxDetails[0]);
        return messageBoxDetailsArray;
    }

    @Override
    public MessageDetails[] getAllAvailableMessages(String messageBoxId) throws MessageBoxException {
        if (this.isAdminLoggedIn()) {
            MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
            if (messageBox != null) {
                return messageBox.getAllMessages();
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxId + " doesn't exists, failed to receive " + "messages."));
            }
            throw this.getNoneExistenceQueueException();
        }
        throw new MessageBoxException("Only the Administrator can receive all messages");
    }

    @Override
    public MessageDetails[] getAllRetrievedMessages(String messageBoxId) throws MessageBoxException {
        return new MessageDetails[0];
    }

    @Override
    public List<PermissionLabel> getAllPermissions(String messageBoxId) throws MessageBoxException {
        return null;
    }

    @Override
    public String deleteMessageBox(String messageBoxId) throws MessageBoxException {
        if (this.isAdminLoggedIn() || messageBoxId.split(File.separator)[0].equals(this.getLoggedInUser())) {
            MessageBox messageBox = this.messageBoxStore.remove(messageBoxId);
            if (messageBox != null) {
                return messageBoxId;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxId + " doesn't exists, failed to delete " + "messageBox."));
            }
            throw this.getNoneExistenceQueueException();
        }
        throw this.getAccessDeniedException();
    }

    @Override
    public SQSMessage putMessage(String messageBoxName, SQSMessage sqsMessage) throws MessageBoxException {
        if (this.isAccessible(messageBoxName, "SendMessage")) {
            MessageBox messageBox = this.messageBoxStore.get(messageBoxName);
            if (messageBox != null) {
                String sender = this.getLoggedInUser() != null ? this.getLoggedInUser() : messageBoxName.split(File.separator)[0];
                sqsMessage.setSenderId(sender);
                messageBox.putMessage(sqsMessage);
                return sqsMessage;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxName + " doesn't exists, failed to put Message."));
            }
            throw this.getNoneExistenceQueueException();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("No permission to Send Message to " + messageBoxName));
        }
        throw this.getAccessDeniedException();
    }

    @Override
    public List<SQSMessage> receiveMessage(String messageBoxId, int numberOfMaximumMessages, long visibilityTimeout, Map<String, String> attributes) throws MessageBoxException {
        if (this.isAccessible(messageBoxId, "ReceiveMessage")) {
            MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
            if (messageBox != null) {
                if (numberOfMaximumMessages > 0 && numberOfMaximumMessages < 11) {
                    return messageBox.receiveMessage(numberOfMaximumMessages, visibilityTimeout, attributes);
                }
                throw new MessageBoxException("The value for MaxNumberOfMessages is not valid", "ReadCountOutOfRange ");
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxId + " doesn't exists, failed to receive " + "messages."));
            }
            throw this.getNoneExistenceQueueException();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("No permission to Send Message to " + messageBoxId));
        }
        throw this.getAccessDeniedException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deleteMessage(String messageBoxId, String receiptHandler) throws MessageBoxException {
        if (!this.isAccessible(messageBoxId, "DeleteMessage")) {
            if (!log.isWarnEnabled()) throw this.getAccessDeniedException();
            log.warn((Object)("No permission to Send Message to " + messageBoxId));
            throw this.getAccessDeniedException();
        }
        MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
        if (messageBox == null) {
            if (!log.isWarnEnabled()) throw this.getNoneExistenceQueueException();
            log.warn((Object)(messageBoxId + " doesn't exists, failed to delete" + " message."));
            throw this.getNoneExistenceQueueException();
        }
        if (messageBox.deleteMessage(receiptHandler) == null) {
            throw new MessageBoxException(receiptHandler + " ,No such receiptHandler exists" + " with " + messageBoxId);
        }
        if (!log.isInfoEnabled()) return;
        log.info((Object)("Message with receiptHandler " + receiptHandler + " successfully" + " deleted."));
    }

    @Override
    public List<String> listQueues(String qnamePrefix) throws MessageBoxException {
        ArrayList<String> queueNameList = new ArrayList<String>();
        if (this.isAdminLoggedIn()) {
            for (String messageBoxName : this.messageBoxStore.keySet()) {
                if (!messageBoxName.split(File.separator)[1].startsWith(qnamePrefix)) continue;
                queueNameList.add(messageBoxName);
            }
        } else {
            for (String messageBoxName : this.messageBoxStore.keySet()) {
                if (!messageBoxName.split(File.separator)[0].equals(this.getLoggedInUser()) || !messageBoxName.split(File.separator)[1].startsWith(qnamePrefix)) continue;
                queueNameList.add(messageBoxName);
            }
        }
        return queueNameList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void changeVisibility(String messageBoxId, String receiptHandler, long visibilityTimeout) throws MessageBoxException {
        if (!this.isAccessible(messageBoxId, "ChangeMessageVisibility")) {
            if (!log.isWarnEnabled()) throw this.getAccessDeniedException();
            log.warn((Object)("No permission to Change Message Visibility in " + messageBoxId));
            throw this.getAccessDeniedException();
        }
        MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
        if (messageBox == null) {
            if (!log.isWarnEnabled()) throw this.getNoneExistenceQueueException();
            log.warn((Object)(messageBoxId + " doesn't exists, failed to change" + " visibilityTimeout."));
            throw this.getNoneExistenceQueueException();
        }
        if (messageBox.changeVisibilityTimeout(receiptHandler, visibilityTimeout) == null) {
            throw new MessageBoxException(receiptHandler + " ,No such receiptHandler exists " + "with " + messageBox);
        }
        if (!log.isInfoEnabled()) return;
        log.info((Object)("VisibilityTimeout of message with receiptHandler " + receiptHandler + " successfully changed to " + visibilityTimeout));
    }

    @Override
    public Map<String, String> getMessageBoxAttributes(String messageBoxId) throws MessageBoxException {
        if (this.isAccessible(messageBoxId, "GetQueueAttributes")) {
            MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
            if (messageBox != null) {
                return messageBox.getQueueAttributes();
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxId + " doesn't exists, failed to get" + " messagebox attributes."));
            }
            throw this.getNoneExistenceQueueException();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("No permission to Get MessageBox Attributes in " + messageBoxId));
        }
        throw this.getAccessDeniedException();
    }

    @Override
    public void setMessageBoxAttributes(String messageBoxId, Map<String, String> attributes) throws MessageBoxException {
        MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
        if (messageBox == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxId + " doesn't exists, failed to set" + " messagebox attributes."));
            }
            throw this.getNoneExistenceQueueException();
        }
        messageBox.setQueueAttributes(attributes);
    }

    @Override
    public void removePermission(String messageBoxId, String permissionLabelName) throws MessageBoxException {
        MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
        if (messageBox == null) {
            throw this.getNoneExistenceQueueException();
        }
        if (!this.isAdminLoggedIn() && !messageBoxId.split(File.separator)[0].equals(this.getLoggedInUser())) {
            throw new MessageBoxException(this.getLoggedInUser() + " has no permission to remove permission on shared message box  " + messageBoxId);
        }
        messageBox.removePermission(permissionLabelName);
    }

    @Override
    public void addPermission(String messageBoxId, List<String> operationsList, String permissionLabelName, List<String> sharedUsersList) throws MessageBoxException {
        MessageBox messageBox = this.messageBoxStore.get(messageBoxId);
        if (messageBox == null) {
            throw this.getNoneExistenceQueueException();
        }
        if (!this.isAdminLoggedIn() && !messageBoxId.split(File.separator)[0].equals(this.getLoggedInUser())) {
            throw new MessageBoxException(this.getLoggedInUser() + " has no permission to remove permission on shared message box  " + messageBoxId);
        }
        messageBox.addPermission(permissionLabelName, sharedUsersList, operationsList);
    }

    private boolean isAccessible(String messageBoxName, String operation) throws MessageBoxException {
        MessageBox messageBox = this.messageBoxStore.get(messageBoxName);
        if (messageBox == null) {
            throw this.getNoneExistenceQueueException();
        }
        if (this.isAdminLoggedIn()) {
            return true;
        }
        String loggedInUser = this.getLoggedInUser();
        if (messageBoxName.split(File.separator)[0].equals(loggedInUser)) {
            return true;
        }
        return messageBox.isSharedForOperation(loggedInUser, operation);
    }

    private String getLoggedInUser() throws MessageBoxException {
        Object userName = MessageContext.getCurrentMessageContext().getProperty("username");
        if (userName != null) {
            String loggedInUser = userName.toString();
            return loggedInUser;
        }
        throw new MessageBoxException("Failed to get logged in user");
    }

    private boolean isAdminLoggedIn() {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String username = (String)request.getSession().getAttribute("wso2carbon.admin.logged.in");
        return username != null;
    }

    private MessageBoxException getNoneExistenceQueueException() {
        return new MessageBoxException("Queue does not exist.", "AWS.SimpleQueueService.NonExistentQueue");
    }

    private MessageBoxException getAccessDeniedException() {
        return new MessageBoxException("Access to the resource is denied.", "AccessDenied ");
    }

    @Override
    public QueueManager getQueueManager() throws MessageBoxException {
        return null;
    }
}

