/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.builder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.messagebox.MessageBoxConfigurationException;
import org.wso2.carbon.messagebox.MessageBoxService;
import org.wso2.carbon.messagebox.MessageBoxServiceFactory;

public class MessageBoxServiceBuilder {
    public static MessageBoxService createMessageBoxService() throws MessageBoxConfigurationException {
        OMElement mbConfig = MessageBoxServiceBuilder.loadConfigXML();
        if (!mbConfig.getQName().equals(new QName("http://wso2.org/carbon/messagebox/", "messageBoxConfig"))) {
            throw new MessageBoxConfigurationException("Invalid root element in message box config");
        }
        OMElement messageBoxService = mbConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/messagebox/", "messageBoxService"));
        String className = messageBoxService.getAttributeValue(new QName(null, "class"));
        try {
            Class<?> messageBoxServiceImplClass = Class.forName(className);
            MessageBoxServiceFactory messageBoxServiceFactory = (MessageBoxServiceFactory)messageBoxServiceImplClass.newInstance();
            return messageBoxServiceFactory.getMessageBoxService(messageBoxService);
        }
        catch (ClassNotFoundException e) {
            throw new MessageBoxConfigurationException("Can not load the class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new MessageBoxConfigurationException("Can not access the class " + className, e);
        }
        catch (InstantiationException e) {
            throw new MessageBoxConfigurationException("Can not instantiate the class " + className, e);
        }
    }

    private static OMElement loadConfigXML() throws MessageBoxConfigurationException {
        String carbonHome = System.getProperty("carbon.home");
        String path = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "messagebox-config.xml";
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new MessageBoxConfigurationException("messagebox-config.xmlcannot be found in the path : " + path, e);
        }
        catch (XMLStreamException e) {
            throw new MessageBoxConfigurationException("Invalid XML for messagebox-config.xml located in the path : " + path, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ignored) {
                throw new MessageBoxConfigurationException("Can not close the input stream");
            }
        }
    }
}

