/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.log4j.Logger;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.apache.qpid.server.security.auth.sasl.JCAProvider;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalDatabaseAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(PrincipalDatabaseAuthenticationManager.class);
    private String _mechanisms;
    private Map<String, CallbackHandler> _callbackHandlerMap = new HashMap<String, CallbackHandler>();
    private Map<String, Map<String, ?>> _serverCreationProperties = new HashMap();
    public static final String PROVIDER_NAME = "AMQSASLProvider-Server";

    public PrincipalDatabaseAuthenticationManager() {
        _logger.info((Object)"Initialising  PrincipalDatabase authentication manager.");
        TreeMap<String, Class<? extends SaslServerFactory>> providerMap = new TreeMap<String, Class<? extends SaslServerFactory>>();
        this.initialiseAuthenticationMechanisms(providerMap, ApplicationRegistry.getInstance().getDatabaseManager().getDatabases());
        if (providerMap.size() > 0) {
            if (Security.insertProviderAt(new JCAProvider(PROVIDER_NAME, providerMap), 1) == -1) {
                _logger.error((Object)"Unable to load custom SASL providers. Qpid custom SASL authenticators unavailable.");
            } else {
                _logger.info((Object)"Additional SASL providers successfully registered.");
            }
        } else {
            _logger.warn((Object)"No additional SASL providers registered.");
        }
    }

    private void initialiseAuthenticationMechanisms(Map<String, Class<? extends SaslServerFactory>> providerMap, Map<String, PrincipalDatabase> databases) {
        if (databases.size() > 1) {
            _logger.warn((Object)"More than one principle database provided currently authentication mechanism will override each other.");
        }
        for (Map.Entry<String, PrincipalDatabase> entry : databases.entrySet()) {
            this.initialiseAuthenticationMechanisms(providerMap, entry.getValue());
        }
    }

    private void initialiseAuthenticationMechanisms(Map<String, Class<? extends SaslServerFactory>> providerMap, PrincipalDatabase database) {
        if (database == null || database.getMechanisms().size() == 0) {
            _logger.warn((Object)"No Database or no mechanisms to initialise authentication");
            return;
        }
        for (Map.Entry<String, AuthenticationProviderInitialiser> mechanism : database.getMechanisms().entrySet()) {
            this.initialiseAuthenticationMechanism(mechanism.getKey(), mechanism.getValue(), providerMap);
        }
    }

    private void initialiseAuthenticationMechanism(String mechanism, AuthenticationProviderInitialiser initialiser, Map<String, Class<? extends SaslServerFactory>> providerMap) {
        this._mechanisms = this._mechanisms == null ? mechanism : this._mechanisms + " " + mechanism;
        this._callbackHandlerMap.put(mechanism, initialiser.getCallbackHandler());
        this._serverCreationProperties.put(mechanism, initialiser.getProperties());
        Class<? extends SaslServerFactory> factory = initialiser.getServerFactoryClassForJCARegistration();
        if (factory != null) {
            providerMap.put(mechanism, factory);
        }
        _logger.info((Object)("Initialised " + mechanism + " SASL provider successfully"));
    }

    @Override
    public String getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN) throws SaslException {
        return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, this._serverCreationProperties.get(mechanism), this._callbackHandlerMap.get(mechanism));
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                Subject subject = new Subject();
                subject.getPrincipals().add(new UsernamePrincipal(server.getAuthorizationID()));
                return new AuthenticationResult(subject);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    @Override
    public void close() {
        this._mechanisms = null;
        Security.removeProvider(PROVIDER_NAME);
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        PrincipalDatabase db = ApplicationRegistry.getInstance().getDatabaseManager().getDatabases().values().iterator().next();
        try {
            if (db.verifyPassword(username, password.toCharArray())) {
                Subject subject = new Subject();
                subject.getPrincipals().add(new UsernamePrincipal(username));
                return new AuthenticationResult(subject);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (AccountNotFoundException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
    }
}

