/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityPluginFactory;
import org.apache.qpid.server.security.access.plugins.BasicPlugin;

public class DenyAll
extends BasicPlugin {
    public static final SecurityPluginFactory<DenyAll> FACTORY = new SecurityPluginFactory<DenyAll>(){

        @Override
        public DenyAll newInstance(ConfigurationPlugin config) throws ConfigurationException {
            DenyAllConfiguration configuration = (DenyAllConfiguration)config.getConfiguration(DenyAllConfiguration.class.getName());
            if (configuration == null) {
                return null;
            }
            DenyAll plugin = new DenyAll();
            plugin.configure(configuration);
            return plugin;
        }

        @Override
        public String getPluginName() {
            return DenyAll.class.getName();
        }

        @Override
        public Class<DenyAll> getPluginClass() {
            return DenyAll.class;
        }
    };

    public Result getDefault() {
        return Result.DENIED;
    }

    public static class DenyAllConfiguration
    extends ConfigurationPlugin {
        public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

            @Override
            public List<String> getParentPaths() {
                return Arrays.asList("security.deny-all", "virtualhosts.virtualhost.security.deny-all");
            }

            @Override
            public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
                DenyAllConfiguration instance = new DenyAllConfiguration();
                instance.setConfiguration(path, config);
                return instance;
            }
        };

        public String[] getElementsProcessed() {
            return new String[]{""};
        }

        public void validateConfiguration() throws ConfigurationException {
            if (!this._configuration.isEmpty()) {
                throw new ConfigurationException("deny-all section takes no elements.");
            }
        }
    }
}

