/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.net.SocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityPlugin;
import org.apache.qpid.server.security.SecurityPluginFactory;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityManager {
    private static final Logger _logger = Logger.getLogger(SecurityManager.class);
    private static final ThreadLocal<Principal> _principal = new ThreadLocal();
    private PluginManager _pluginManager;
    private Map<String, SecurityPluginFactory> _pluginFactories = new HashMap<String, SecurityPluginFactory>();
    private Map<String, SecurityPlugin> _globalPlugins = new HashMap<String, SecurityPlugin>();
    private Map<String, SecurityPlugin> _hostPlugins = new HashMap<String, SecurityPlugin>();

    public SecurityManager(SecurityManager parent) throws ConfigurationException {
        this._pluginManager = parent._pluginManager;
        this._pluginFactories = parent._pluginFactories;
        this._globalPlugins = parent._hostPlugins;
    }

    public SecurityManager(ConfigurationPlugin configuration, PluginManager manager) throws ConfigurationException {
        this(configuration, manager, null);
    }

    public SecurityManager(ConfigurationPlugin configuration, PluginManager manager, SecurityPluginFactory plugin) throws ConfigurationException {
        this._pluginManager = manager;
        if (manager == null) {
            return;
        }
        this._pluginFactories = this._pluginManager.getSecurityPlugins();
        if (plugin != null) {
            this._pluginFactories.put(plugin.getPluginName(), plugin);
        }
        this.configureHostPlugins(configuration);
    }

    public static Principal getThreadPrincipal() {
        return _principal.get();
    }

    public static void setThreadPrincipal(Principal principal) {
        _principal.set(principal);
    }

    public static void setThreadPrincipal(String authId) {
        SecurityManager.setThreadPrincipal(new UsernamePrincipal(authId));
    }

    public void configureHostPlugins(ConfigurationPlugin hostConfig) throws ConfigurationException {
        this._hostPlugins = this.configurePlugins(hostConfig);
    }

    public void configureGlobalPlugins(ConfigurationPlugin configuration) throws ConfigurationException {
        this._globalPlugins = this.configurePlugins(configuration);
    }

    public Map<String, SecurityPlugin> configurePlugins(ConfigurationPlugin hostConfig) throws ConfigurationException {
        HashMap<String, SecurityPlugin> plugins = new HashMap<String, SecurityPlugin>();
        SecurityConfiguration securityConfig = (SecurityConfiguration)hostConfig.getConfiguration(SecurityConfiguration.class.getName());
        if (securityConfig != null) {
            for (SecurityPluginFactory factory : this._pluginFactories.values()) {
                SecurityPlugin plugin = (SecurityPlugin)factory.newInstance(securityConfig);
                if (plugin == null) continue;
                plugins.put(factory.getPluginName(), plugin);
            }
        }
        return plugins;
    }

    public void addHostPlugin(SecurityPlugin plugin) {
        this._hostPlugins.put(plugin.getClass().getName(), plugin);
    }

    public static Logger getLogger() {
        return _logger;
    }

    private boolean checkAllPlugins(AccessCheck checker) {
        HashMap<String, SecurityPlugin> remainingPlugins = new HashMap<String, SecurityPlugin>(this._globalPlugins);
        for (Map.Entry<String, SecurityPlugin> hostEntry : this._hostPlugins.entrySet()) {
            Result host;
            SecurityPlugin globalPlugin = remainingPlugins.get(hostEntry.getKey());
            if (globalPlugin != null) {
                remainingPlugins.remove(hostEntry.getKey());
            }
            if ((host = checker.allowed(hostEntry.getValue())) == Result.DENIED) {
                return false;
            }
            if (host == Result.ALLOWED) continue;
            if (globalPlugin == null) {
                if (host == Result.DEFER) {
                    host = hostEntry.getValue().getDefault();
                }
                if (host != Result.DENIED) continue;
                return false;
            }
            Result global = checker.allowed(globalPlugin);
            if (global == Result.DEFER) {
                global = globalPlugin.getDefault();
            }
            if (global == Result.ABSTAIN && host == Result.DEFER) {
                global = hostEntry.getValue().getDefault();
            }
            if (global != Result.DENIED) continue;
            return false;
        }
        for (SecurityPlugin plugin : remainingPlugins.values()) {
            Result remaining = checker.allowed(plugin);
            if (remaining == Result.DEFER) {
                remaining = plugin.getDefault();
            }
            if (remaining != Result.DENIED) continue;
            return false;
        }
        return true;
    }

    public boolean authoriseBind(final Exchange exch, final AMQQueue queue, final AMQShortString routingKey) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.BIND, ObjectType.EXCHANGE, new ObjectProperties(exch, queue, routingKey));
            }
        });
    }

    public boolean authoriseObject(final String packageName, final String className) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                ObjectProperties properties = new ObjectProperties();
                properties.put(ObjectProperties.Property.PACKAGE, packageName);
                properties.put(ObjectProperties.Property.CLASS, className);
                return plugin.authorise(Operation.ACCESS, ObjectType.OBJECT, properties);
            }
        });
    }

    public boolean authoriseMethod(final Operation operation, final String componentName, final String methodName) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                ObjectProperties properties = new ObjectProperties();
                properties.setName(methodName);
                if (componentName != null) {
                    properties.put(ObjectProperties.Property.COMPONENT, componentName);
                }
                return plugin.authorise(operation, ObjectType.METHOD, properties);
            }
        });
    }

    public boolean accessVirtualhost(String vhostname, final SocketAddress remoteAddress) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.access(ObjectType.VIRTUALHOST, remoteAddress);
            }
        });
    }

    public boolean authoriseConsume(final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.CONSUME, ObjectType.QUEUE, new ObjectProperties(queue));
            }
        });
    }

    public boolean authoriseConsume(final boolean exclusive, final boolean noAck, final boolean noLocal, final boolean nowait, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.CONSUME, ObjectType.QUEUE, new ObjectProperties(exclusive, noAck, noLocal, nowait, queue));
            }
        });
    }

    public boolean authoriseCreateExchange(final Boolean autoDelete, final Boolean durable, final AMQShortString exchangeName, final Boolean internal, final Boolean nowait, final Boolean passive, final AMQShortString exchangeType) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.CREATE, ObjectType.EXCHANGE, new ObjectProperties(autoDelete, durable, exchangeName, internal, nowait, passive, exchangeType));
            }
        });
    }

    public boolean authoriseCreateQueue(final Boolean autoDelete, final Boolean durable, final Boolean exclusive, final Boolean nowait, final Boolean passive, final AMQShortString queueName, final String owner) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.CREATE, ObjectType.QUEUE, new ObjectProperties(autoDelete, durable, exclusive, nowait, passive, queueName, owner));
            }
        });
    }

    public boolean authoriseDelete(final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.DELETE, ObjectType.QUEUE, new ObjectProperties(queue));
            }
        });
    }

    public boolean authoriseDelete(final Exchange exchange) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.DELETE, ObjectType.EXCHANGE, new ObjectProperties(exchange.getName()));
            }
        });
    }

    public boolean authorisePublish(final boolean immediate, final String routingKey, final String exchangeName) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.PUBLISH, ObjectType.EXCHANGE, new ObjectProperties(exchangeName, routingKey, immediate));
            }
        });
    }

    public boolean authorisePurge(final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.PURGE, ObjectType.QUEUE, new ObjectProperties(queue));
            }
        });
    }

    public boolean authoriseUnbind(final Exchange exch, final AMQShortString routingKey, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(SecurityPlugin plugin) {
                return plugin.authorise(Operation.UNBIND, ObjectType.EXCHANGE, new ObjectProperties(exch, queue, routingKey));
            }
        });
    }

    private abstract class AccessCheck {
        private AccessCheck() {
        }

        abstract Result allowed(SecurityPlugin var1);
    }

    public static class SecurityConfiguration
    extends ConfigurationPlugin {
        public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

            @Override
            public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
                SecurityConfiguration instance = new SecurityConfiguration();
                instance.setConfiguration(path, config);
                return instance;
            }

            @Override
            public List<String> getParentPaths() {
                return Arrays.asList("security", "virtualhosts.virtualhost.security");
            }
        };

        public String[] getElementsProcessed() {
            return new String[]{"security"};
        }

        public void validateConfiguration() throws ConfigurationException {
            if (this._configuration.isEmpty()) {
                throw new ConfigurationException("security section is incomplete, no elements found.");
            }
        }
    }
}

