/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.AMQException;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.Filterable;
import org.apache.qpid.server.subscription.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface QueueEntry
extends Comparable<QueueEntry>,
Filterable {
    public static final EntryState AVAILABLE_STATE = new AvailableState();
    public static final EntryState DELETED_STATE = new DeletedState();
    public static final EntryState DEQUEUED_STATE = new DequeuedState();
    public static final EntryState EXPIRED_STATE = new ExpiredState();
    public static final EntryState NON_SUBSCRIPTION_ACQUIRED_STATE = new NonSubscriptionAcquiredState();

    public AMQQueue getQueue();

    public ServerMessage getMessage();

    public long getSize();

    public boolean getDeliveredToConsumer();

    public boolean expired() throws AMQException;

    public boolean isAvailable();

    public boolean isAcquired();

    public boolean acquire();

    public boolean acquire(Subscription var1);

    public boolean delete();

    public boolean isDeleted();

    public boolean acquiredBySubscription();

    public boolean isAcquiredBy(Subscription var1);

    public void release();

    public boolean releaseButRetain();

    public boolean immediateAndNotDelivered();

    public void setRedelivered();

    @Override
    public boolean isRedelivered();

    public Subscription getDeliveredSubscription();

    public void reject();

    public void reject(Subscription var1);

    public boolean isRejectedBy(Subscription var1);

    public void dequeue();

    public void dispose();

    public void discard();

    public void routeToAlternate();

    public boolean isQueueDeleted();

    public void addStateChangeListener(StateChangeListener var1);

    public boolean removeStateChangeListener(StateChangeListener var1);

    public boolean isDequeued();

    public boolean isDispensed();

    public static final class SubscriptionAssignedState
    extends EntryState {
        private final Subscription _subscription;

        public SubscriptionAssignedState(Subscription subscription) {
            this._subscription = subscription;
        }

        public State getState() {
            return State.AVAILABLE;
        }

        public Subscription getSubscription() {
            return this._subscription;
        }
    }

    public static final class SubscriptionAcquiredState
    extends EntryState {
        private final Subscription _subscription;

        public SubscriptionAcquiredState(Subscription subscription) {
            this._subscription = subscription;
        }

        public State getState() {
            return State.ACQUIRED;
        }

        public Subscription getSubscription() {
            return this._subscription;
        }
    }

    public static final class NonSubscriptionAcquiredState
    extends EntryState {
        public State getState() {
            return State.ACQUIRED;
        }
    }

    public static final class ExpiredState
    extends EntryState {
        public State getState() {
            return State.EXPIRED;
        }
    }

    public static final class DeletedState
    extends EntryState {
        public State getState() {
            return State.DELETED;
        }
    }

    public static final class DequeuedState
    extends EntryState {
        public State getState() {
            return State.DEQUEUED;
        }
    }

    public static final class AvailableState
    extends EntryState {
        public State getState() {
            return State.AVAILABLE;
        }
    }

    public static abstract class EntryState {
        private EntryState() {
        }

        public abstract State getState();

        public boolean isDispensed() {
            State currentState = this.getState();
            return currentState == State.DEQUEUED || currentState == State.DELETED;
        }
    }

    public static interface StateChangeListener {
        public void stateChanged(QueueEntry var1, State var2, State var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        AVAILABLE,
        ACQUIRED,
        EXPIRED,
        DEQUEUED,
        DELETED;

    }
}

