/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.message.MessageMetaData;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.Filterable;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.store.StoredMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingMessage
implements Filterable,
InboundMessage,
EnqueableMessage,
MessageContentSource {
    private static final Logger _logger = Logger.getLogger(IncomingMessage.class);
    private static final boolean SYNCHED_CLOCKS = ApplicationRegistry.getInstance().getConfiguration().getSynchedClocks();
    private final MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private long _bodyLengthReceived = 0L;
    private ArrayList<? extends BaseQueue> _destinationQueues;
    private long _expiration;
    private Exchange _exchange;
    private int _receivedChunkCount = 0;
    private List<ContentChunk> _contentChunks = new ArrayList<ContentChunk>();
    private MessageMetaData _messageMetaData;
    private StoredMessage<MessageMetaData> _storedMessageHandle;

    public IncomingMessage(MessagePublishInfo info) {
        this._messagePublishInfo = info;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) throws AMQException {
        this._contentHeaderBody = contentHeaderBody;
    }

    public void setExpiration() {
        long diff;
        long expiration = ((BasicContentHeaderProperties)this._contentHeaderBody.getProperties()).getExpiration();
        long timestamp = ((BasicContentHeaderProperties)this._contentHeaderBody.getProperties()).getTimestamp();
        if (SYNCHED_CLOCKS) {
            this._expiration = expiration;
        } else if (expiration != 0L && timestamp != 0L && ((diff = System.currentTimeMillis() - timestamp) > 1000L || diff < 1000L)) {
            this._expiration = expiration + diff;
        }
    }

    public MessageMetaData headersReceived() {
        this._messageMetaData = new MessageMetaData(this._messagePublishInfo, this._contentHeaderBody, 0);
        return this._messageMetaData;
    }

    public ArrayList<? extends BaseQueue> getDestinationQueues() {
        return this._destinationQueues;
    }

    public int addContentBodyFrame(ContentChunk contentChunk) throws AMQException {
        this._storedMessageHandle.addContent((int)this._bodyLengthReceived, contentChunk.getData().buf());
        this._bodyLengthReceived += (long)contentChunk.getSize();
        this._contentChunks.add(contentChunk);
        return this._receivedChunkCount++;
    }

    public boolean allContentReceived() {
        return this._bodyLengthReceived == this.getContentHeader().bodySize;
    }

    public AMQShortString getExchange() {
        return this._messagePublishInfo.getExchange();
    }

    @Override
    public String getRoutingKey() {
        return this._messagePublishInfo.getRoutingKey() == null ? null : this._messagePublishInfo.getRoutingKey().toString();
    }

    public String getBinding() {
        return this._messagePublishInfo.getRoutingKey() == null ? null : this._messagePublishInfo.getRoutingKey().toString();
    }

    public boolean isMandatory() {
        return this._messagePublishInfo.isMandatory();
    }

    public boolean isImmediate() {
        return this._messagePublishInfo.isImmediate();
    }

    public ContentHeaderBody getContentHeader() {
        return this._contentHeaderBody;
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this._messageMetaData.getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        return this.getContentHeader().getProperties() instanceof BasicContentHeaderProperties && ((BasicContentHeaderProperties)this.getContentHeader().getProperties()).getDeliveryMode() == 2;
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return this.getContentHeader().bodySize;
    }

    @Override
    public Long getMessageNumber() {
        return this._storedMessageHandle.getMessageNumber();
    }

    public void setExchange(Exchange e) {
        this._exchange = e;
    }

    public void route() {
        this.enqueue(this._exchange.route(this));
    }

    public void enqueue(ArrayList<? extends BaseQueue> queues) {
        this._destinationQueues = queues;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public int getReceivedChunkCount() {
        return this._receivedChunkCount;
    }

    public int getBodyCount() throws AMQException {
        return this._contentChunks.size();
    }

    public ContentChunk getContentChunk(int index) throws IllegalArgumentException, AMQException {
        return this._contentChunks.get(index);
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        int pos = 0;
        int written = 0;
        for (ContentChunk cb : this._contentChunks) {
            ByteBuffer data = cb.getData().buf();
            if (offset + written >= pos && offset < pos + data.limit()) {
                ByteBuffer src = data.duplicate();
                src.position(offset + written - pos);
                src = src.slice();
                if (buf.remaining() < src.limit()) {
                    src.limit(buf.remaining());
                }
                int count = src.limit();
                buf.put(src);
                written += count;
                if (buf.remaining() == 0) break;
            }
            pos += data.limit();
        }
        return written;
    }

    public void setStoredMessage(StoredMessage<MessageMetaData> storedMessageHandle) {
        this._storedMessageHandle = storedMessageHandle;
    }

    public StoredMessage<MessageMetaData> getStoredMessage() {
        return this._storedMessageHandle;
    }
}

