/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.net.SocketAddress;
import java.util.UUID;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.ConnectionConfig;
import org.apache.qpid.server.configuration.ConnectionConfigType;
import org.apache.qpid.server.configuration.VirtualHostConfig;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.transport.NetworkDriver;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;

public class ProtocolEngine_0_10
extends InputHandler
implements ProtocolEngine,
ConnectionConfig {
    public static final int MAX_FRAME_SIZE = 65535;
    private NetworkDriver _networkDriver;
    private long _readBytes;
    private long _writtenBytes;
    private ServerConnection _connection;
    private final UUID _id;
    private final IApplicationRegistry _appRegistry;
    private long _createTime = System.currentTimeMillis();

    public ProtocolEngine_0_10(ServerConnection conn, NetworkDriver networkDriver, IApplicationRegistry appRegistry) {
        super(new Assembler(conn));
        this._connection = conn;
        this._connection.setConnectionConfig(this);
        this._networkDriver = networkDriver;
        this._id = appRegistry.getConfigStore().createId();
        this._appRegistry = appRegistry;
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, null, false, false));
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, "0-10", false, true));
    }

    public void setNetworkDriver(NetworkDriver driver) {
        this._networkDriver = driver;
        Disassembler dis = new Disassembler(driver, 65535);
        this._connection.setSender(dis);
        this._connection.onOpen(new Runnable(){

            public void run() {
                ProtocolEngine_0_10.this.getConfigStore().addConfiguredObject(ProtocolEngine_0_10.this);
            }
        });
    }

    public SocketAddress getRemoteAddress() {
        return this._networkDriver.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._networkDriver.getLocalAddress();
    }

    public long getReadBytes() {
        return this._readBytes;
    }

    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    public void writerIdle() {
    }

    public void readerIdle() {
    }

    public VirtualHostConfig getVirtualHost() {
        return this._connection.getVirtualHost();
    }

    public String getAddress() {
        return this.getRemoteAddress().toString();
    }

    public Boolean isIncoming() {
        return true;
    }

    public Boolean isSystemConnection() {
        return false;
    }

    public Boolean isFederationLink() {
        return false;
    }

    public String getAuthId() {
        return this._connection.getAuthorizationID();
    }

    public String getRemoteProcessName() {
        return null;
    }

    public Integer getRemotePID() {
        return null;
    }

    public Integer getRemoteParentPID() {
        return null;
    }

    public ConfigStore getConfigStore() {
        return this._appRegistry.getConfigStore();
    }

    public UUID getId() {
        return this._id;
    }

    public ConnectionConfigType getConfigType() {
        return ConnectionConfigType.getInstance();
    }

    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    public boolean isDurable() {
        return false;
    }

    public void closed() {
        super.closed();
        this.getConfigStore().removeConfiguredObject(this);
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public Boolean isShadow() {
        return false;
    }

    public void mgmtClose() {
        this._connection.mgmtClose();
    }
}

