/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxCommitHandler
implements StateAwareMethodListener<TxCommitBody> {
    private static final Logger _log = Logger.getLogger(TxCommitHandler.class);
    private static TxCommitHandler _instance = new TxCommitHandler();

    public static TxCommitHandler getInstance() {
        return _instance;
    }

    private TxCommitHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, TxCommitBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        try {
            AMQChannel channel;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Commit received on channel " + channelId));
            }
            if ((channel = session.getChannel(channelId)) == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            channel.commit();
            MethodRegistry methodRegistry = session.getMethodRegistry();
            TxCommitOkBody responseBody = methodRegistry.createTxCommitOkBody();
            session.writeFrame(responseBody.generateFrame(channelId));
        }
        catch (AMQException e) {
            throw body.getChannelException(e.getErrorCode(), "Failed to commit: " + e.getMessage());
        }
    }
}

