/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRejectMethodHandler
implements StateAwareMethodListener<BasicRejectBody> {
    private static final Logger _logger = Logger.getLogger(BasicRejectMethodHandler.class);
    private static BasicRejectMethodHandler _instance = new BasicRejectMethodHandler();

    public static BasicRejectMethodHandler getInstance() {
        return _instance;
    }

    private BasicRejectMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicRejectBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Rejecting:" + body.getDeliveryTag() + ": Requeue:" + body.getRequeue() + " on channel:" + channel.debugIdentity()));
        }
        long deliveryTag = body.getDeliveryTag();
        QueueEntry message = channel.getUnacknowledgedMessageMap().get(deliveryTag);
        if (message == null) {
            _logger.warn((Object)("Dropping reject request as message is null for tag:" + deliveryTag));
        } else {
            if (message.isQueueDeleted()) {
                _logger.warn((Object)"Message's Queue as already been purged, unable to Reject. Dropping message should use Dead Letter Queue");
                message = channel.getUnacknowledgedMessageMap().remove(deliveryTag);
                if (message != null) {
                    message.discard();
                }
                return;
            }
            if (message.getMessage() == null) {
                _logger.warn((Object)"Message as already been purged, unable to Reject.");
                return;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Rejecting: DT:" + deliveryTag + "-" + message.getMessage() + ": Requeue:" + body.getRequeue() + " on channel:" + channel.debugIdentity()));
            }
            message.reject();
            if (body.getRequeue()) {
                channel.requeue(deliveryTag);
            } else {
                _logger.warn((Object)"Dropping message as requeue not required and there is no dead letter queue");
                message = channel.getUnacknowledgedMessageMap().remove(deliveryTag);
            }
        }
    }
}

