/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.AMQUnknownExchangeType;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.qmf.ManagementExchange;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.exchange.DirectExchange;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.exchange.FanoutExchange;
import org.apache.qpid.server.exchange.HeadersExchange;
import org.apache.qpid.server.exchange.TopicExchange;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchangeFactory
implements ExchangeFactory {
    private static final Logger _logger = Logger.getLogger(DefaultExchangeFactory.class);
    private Map<AMQShortString, ExchangeType<? extends Exchange>> _exchangeClassMap = new HashMap<AMQShortString, ExchangeType<? extends Exchange>>();
    private final VirtualHost _host;

    public DefaultExchangeFactory(VirtualHost host) {
        this._host = host;
        this.registerExchangeType(DirectExchange.TYPE);
        this.registerExchangeType(TopicExchange.TYPE);
        this.registerExchangeType(HeadersExchange.TYPE);
        this.registerExchangeType(FanoutExchange.TYPE);
        this.registerExchangeType(ManagementExchange.TYPE);
    }

    public void registerExchangeType(ExchangeType<? extends Exchange> type) {
        this._exchangeClassMap.put(type.getName(), type);
    }

    @Override
    public Collection<ExchangeType<? extends Exchange>> getRegisteredTypes() {
        return this._exchangeClassMap.values();
    }

    @Override
    public Collection<ExchangeType<? extends Exchange>> getPublicCreatableTypes() {
        ArrayList<ExchangeType<? extends Exchange>> publicTypes = new ArrayList<ExchangeType<? extends Exchange>>();
        publicTypes.addAll(this._exchangeClassMap.values());
        publicTypes.remove(ManagementExchange.TYPE);
        return publicTypes;
    }

    @Override
    public Exchange createExchange(String exchange, String type, boolean durable, boolean autoDelete) throws AMQException {
        return this.createExchange(new AMQShortString(exchange), new AMQShortString(type), durable, autoDelete, 0);
    }

    @Override
    public Exchange createExchange(AMQShortString exchange, AMQShortString type, boolean durable, boolean autoDelete, int ticket) throws AMQException {
        if (!this._host.getSecurityManager().authoriseCreateExchange(autoDelete, durable, exchange, null, null, null, type)) {
            String description = "Permission denied: exchange-name '" + exchange.asString() + "'";
            throw new AMQSecurityException(description);
        }
        ExchangeType<? extends Exchange> exchType = this._exchangeClassMap.get(type);
        if (exchType == null) {
            throw new AMQUnknownExchangeType("Unknown exchange type: " + type, null);
        }
        Exchange e = exchType.newInstance(this._host, exchange, durable, ticket, autoDelete);
        return e;
    }

    @Override
    public void initialise(VirtualHostConfiguration hostConfig) {
        if (hostConfig == null) {
            return;
        }
        for (Object className : hostConfig.getCustomExchanges()) {
            try {
                ExchangeType<?> exchangeType = ApplicationRegistry.getInstance().getPluginManager().getExchanges().get(String.valueOf(className));
                if (exchangeType == null) {
                    _logger.error((Object)("No such custom exchange class found: \"" + String.valueOf(className) + "\""));
                    return;
                }
                Class<?> exchangeTypeClass = exchangeType.getClass();
                ExchangeType type = (ExchangeType)exchangeTypeClass.newInstance();
                this.registerExchangeType(type);
            }
            catch (ClassCastException classCastEx) {
                _logger.error((Object)("No custom exchange class: \"" + String.valueOf(className) + "\" cannot be registered as it does not extend class \"" + ExchangeType.class + "\""));
            }
            catch (IllegalAccessException e) {
                _logger.error((Object)("Cannot create custom exchange class: \"" + String.valueOf(className) + "\""), (Throwable)e);
            }
            catch (InstantiationException e) {
                _logger.error((Object)("Cannot create custom exchange class: \"" + String.valueOf(className) + "\""), (Throwable)e);
            }
        }
    }
}

