/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.Collection;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMethod;
import org.apache.qpid.qmf.QMFOperation;
import org.apache.qpid.qmf.QMFProperty;
import org.apache.qpid.qmf.QMFSchemaRequestCommand;
import org.apache.qpid.qmf.QMFStatistic;
import org.apache.qpid.transport.codec.BBEncoder;

public class QMFSchemaResponseCommand
extends QMFCommand {
    private final QMFClass _qmfClass;

    public QMFSchemaResponseCommand(QMFSchemaRequestCommand qmfSchemaRequestCommand, QMFClass qmfClass) {
        super(new QMFCommandHeader(qmfSchemaRequestCommand.getHeader().getVersion(), qmfSchemaRequestCommand.getHeader().getSeq(), QMFOperation.SCHEMA_RESPONSE));
        this._qmfClass = qmfClass;
    }

    public void encode(BBEncoder encoder) {
        super.encode(encoder);
        encoder.writeUint8(this._qmfClass.getType().getValue());
        encoder.writeStr8(this._qmfClass.getPackage().getName());
        encoder.writeStr8(this._qmfClass.getName());
        encoder.writeBin128(this._qmfClass.getSchemaHash());
        Collection<QMFProperty> props = this._qmfClass.getProperties();
        Collection<QMFStatistic> stats = this._qmfClass.getStatistics();
        Collection<QMFMethod> methods = this._qmfClass.getMethods();
        encoder.writeUint16(props.size());
        if (this._qmfClass.getType() == QMFClass.Type.OBJECT) {
            encoder.writeUint16(stats.size());
            encoder.writeUint16(methods.size());
        }
        for (QMFProperty prop : props) {
            prop.encode(encoder);
        }
        if (this._qmfClass.getType() == QMFClass.Type.OBJECT) {
            for (QMFStatistic stat : stats) {
                stat.encode(encoder);
            }
            for (QMFMethod method : methods) {
                method.encode(encoder);
            }
        }
    }
}

