/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.mbeans;

import java.io.IOException;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanException;
import org.apache.qpid.management.common.mbeans.annotations.MBeanAttribute;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperationParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ManagedBroker {
    public static final String TYPE = "VirtualHostManager";

    @MBeanAttribute(name="ExchangeTypes", description="The types of Exchange available for creation.")
    public String[] getExchangeTypes() throws IOException;

    @MBeanOperation(name="retrieveQueueAttributeNames", description="Retrieve the attribute names for queues in this virtualhost", impact=0)
    public List<String> retrieveQueueAttributeNames() throws IOException;

    @MBeanOperation(name="retrieveQueueAttributeValues", description="Retrieve the indicated attributes for queues in this virtualhost", impact=0)
    public List<List<Object>> retrieveQueueAttributeValues(@MBeanOperationParameter(name="attributes", description="Attributes to retrieve") String[] var1) throws IOException;

    @MBeanOperation(name="createNewExchange", description="Creates a new Exchange", impact=1)
    public void createNewExchange(@MBeanOperationParameter(name="name", description="Name of the new exchange") String var1, @MBeanOperationParameter(name="ExchangeType", description="Type of the exchange") String var2, @MBeanOperationParameter(name="durable", description="true if the Exchang should be durable") boolean var3) throws IOException, JMException, MBeanException;

    @MBeanOperation(name="unregisterExchange", description="Unregisters all the related channels and queuebindings of this exchange", impact=1)
    public void unregisterExchange(@MBeanOperationParameter(name="Exchange", description="Exchange Name") String var1) throws IOException, JMException, MBeanException;

    @MBeanOperation(name="createNewQueue", description="Create a new Queue on the Broker server", impact=1)
    public void createNewQueue(@MBeanOperationParameter(name="queue name", description="Name of the new queue") String var1, @MBeanOperationParameter(name="owner", description="Owner name") String var2, @MBeanOperationParameter(name="durable", description="true if the queue should be durable") boolean var3) throws IOException, JMException, MBeanException;

    @MBeanOperation(name="deleteQueue", description="Unregisters the Queue bindings, removes the subscriptions and deletes the queue", impact=1)
    public void deleteQueue(@MBeanOperationParameter(name="Queue", description="Queue Name") String var1) throws IOException, JMException, MBeanException;

    @MBeanOperation(name="resetStatistics", description="Resets all message and data statistics for the virtual host", impact=1)
    public void resetStatistics() throws Exception;

    @MBeanAttribute(name="PeakMessageDeliveryRate", description="VirtualHostManager Peak Message Delivery Rate")
    public double getPeakMessageDeliveryRate();

    @MBeanAttribute(name="PeakDataDeliveryRate", description="VirtualHostManager Peak Data Delivery Rate")
    public double getPeakDataDeliveryRate();

    @MBeanAttribute(name="MessageDeliveryRate", description="VirtualHostManager Message Delivery Rate")
    public double getMessageDeliveryRate();

    @MBeanAttribute(name="DataDeliveryRate", description="VirtualHostManager Data Delivery Rate")
    public double getDataDeliveryRate();

    @MBeanAttribute(name="TotalMessagesDelivered", description="VirtualHostManager Total Messages Delivered")
    public long getTotalMessagesDelivered();

    @MBeanAttribute(name="TotalDataDelivered", description="VirtualHostManager Total Data Delivered")
    public long getTotalDataDelivered();

    @MBeanAttribute(name="PeakMessageReceiptRate", description="VirtualHostManager Peak Message Receipt Rate")
    public double getPeakMessageReceiptRate();

    @MBeanAttribute(name="PeakDataReceiptRate", description="VirtualHostManager Peak Data Receipt Rate")
    public double getPeakDataReceiptRate();

    @MBeanAttribute(name="MessageReceiptRate", description="VirtualHostManager Message Receipt Rate")
    public double getMessageReceiptRate();

    @MBeanAttribute(name="DataReceiptRate", description="VirtualHostManager Data Receipt Rate")
    public double getDataReceiptRate();

    @MBeanAttribute(name="TotalMessagesReceived", description="VirtualHostManager Total Messages Received")
    public long getTotalMessagesReceived();

    @MBeanAttribute(name="TotalDataReceived", description="VirtualHostManager Total Data Received")
    public long getTotalDataReceived();

    @MBeanAttribute(name="StatisticsEnabled", description="VirtualHostManager Statistics Enabled")
    public boolean isStatisticsEnabled();
}

