/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionSpecificRegistry {
    private static final Logger _log = LoggerFactory.getLogger(VersionSpecificRegistry.class);
    private final byte _protocolMajorVersion;
    private final byte _protocolMinorVersion;
    private static final int DEFAULT_MAX_CLASS_ID = 200;
    private static final int DEFAULT_MAX_METHOD_ID = 50;
    private AMQMethodBodyInstanceFactory[][] _registry = new AMQMethodBodyInstanceFactory[200][];
    private ProtocolVersionMethodConverter _protocolVersionConverter;

    public VersionSpecificRegistry(byte major, byte minor) {
        this._protocolMajorVersion = major;
        this._protocolMinorVersion = minor;
        this._protocolVersionConverter = VersionSpecificRegistry.loadProtocolVersionConverters(major, minor);
    }

    private static ProtocolVersionMethodConverter loadProtocolVersionConverters(byte protocolMajorVersion, byte protocolMinorVersion) {
        try {
            Class<?> versionMethodConverterClass = Class.forName("org.apache.qpid.framing.MethodConverter_" + protocolMajorVersion + "_" + protocolMinorVersion);
            return (ProtocolVersionMethodConverter)versionMethodConverterClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            _log.warn("Could not find protocol conversion classes for " + protocolMajorVersion + "-" + protocolMinorVersion);
            if (protocolMinorVersion != 0) {
                protocolMinorVersion = (byte)(protocolMinorVersion - 1);
                return VersionSpecificRegistry.loadProtocolVersionConverters(protocolMajorVersion, protocolMinorVersion);
            }
            if (protocolMajorVersion != 0) {
                protocolMajorVersion = (byte)(protocolMajorVersion - 1);
                return VersionSpecificRegistry.loadProtocolVersionConverters(protocolMajorVersion, protocolMinorVersion);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to load protocol version converter: ", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to load protocol version converter: ", e);
        }
    }

    public byte getProtocolMajorVersion() {
        return this._protocolMajorVersion;
    }

    public byte getProtocolMinorVersion() {
        return this._protocolMinorVersion;
    }

    public AMQMethodBodyInstanceFactory getMethodBody(short classID, short methodID) {
        try {
            return this._registry[classID][methodID];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void registerMethod(short classID, short methodID, AMQMethodBodyInstanceFactory instanceFactory) {
        if (this._registry.length <= classID) {
            AMQMethodBodyInstanceFactory[][] oldRegistry = this._registry;
            this._registry = new AMQMethodBodyInstanceFactory[classID + 1][];
            System.arraycopy(oldRegistry, 0, this._registry, 0, oldRegistry.length);
        }
        if (this._registry[classID] == null) {
            this._registry[classID] = new AMQMethodBodyInstanceFactory[methodID > 50 ? methodID + 1 : 51];
        } else if (this._registry[classID].length <= methodID) {
            AMQMethodBodyInstanceFactory[] oldMethods = this._registry[classID];
            this._registry[classID] = new AMQMethodBodyInstanceFactory[methodID + 1];
            System.arraycopy(oldMethods, 0, this._registry[classID], 0, oldMethods.length);
        }
        this._registry[classID][methodID] = instanceFactory;
    }

    public AMQMethodBody get(short classID, short methodID, ByteBuffer in, long size) throws AMQFrameDecodingException {
        AMQMethodBodyInstanceFactory bodyFactory;
        try {
            bodyFactory = this._registry[classID][methodID];
        }
        catch (NullPointerException e) {
            throw new AMQFrameDecodingException(null, "Class " + classID + " unknown in AMQP version " + this._protocolMajorVersion + "-" + this._protocolMinorVersion + " (while trying to decode class " + classID + " method " + methodID + ".", e);
        }
        catch (IndexOutOfBoundsException e) {
            if (classID >= this._registry.length) {
                throw new AMQFrameDecodingException(null, "Class " + classID + " unknown in AMQP version " + this._protocolMajorVersion + "-" + this._protocolMinorVersion + " (while trying to decode class " + classID + " method " + methodID + ".", e);
            }
            throw new AMQFrameDecodingException(null, "Method " + methodID + " unknown in AMQP version " + this._protocolMajorVersion + "-" + this._protocolMinorVersion + " (while trying to decode class " + classID + " method " + methodID + ".", e);
        }
        if (bodyFactory == null) {
            throw new AMQFrameDecodingException(null, "Method " + methodID + " unknown in AMQP version " + this._protocolMajorVersion + "-" + this._protocolMinorVersion + " (while trying to decode class " + classID + " method " + methodID + ".", null);
        }
        return bodyFactory.newInstance(in, size);
    }

    public ProtocolVersionMethodConverter getProtocolVersionMethodConverter() {
        return this._protocolVersionConverter;
    }

    public void configure() {
        this._protocolVersionConverter.configure();
    }
}

