/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.qpid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.messagebox.MessageBoxDetails;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.PermissionLabel;
import org.wso2.carbon.messagebox.internal.utils.Utils;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RegistryMessageBoxHandler {
    public RegistryMessageBoxHandler() throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            if (!userRegistry.resourceExists("message/messageBoxes")) {
                userRegistry.put("message/messageBoxes", (Resource)userRegistry.newCollection());
            }
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the user registry ", e);
        }
    }

    public void createMessageBox(String owner, String name, long visibilityTimeout) throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            if (!userRegistry.resourceExists("message/messageBoxes")) {
                userRegistry.put("message/messageBoxes", (Resource)userRegistry.newCollection());
            }
            Collection collection = userRegistry.newCollection();
            collection.setProperty("VisibilityTimeout", String.valueOf(visibilityTimeout));
            collection.setProperty("CreatedTimestamp", Long.toString(System.currentTimeMillis()));
            userRegistry.put(this.getMessageBoxResourcePath(owner, name), (Resource)collection);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not create a new registry collection ", e);
        }
    }

    public boolean isMessageBoxExists(String owner, String name) throws MessageBoxException {
        try {
            return Utils.getUserRegistry().resourceExists(this.getMessageBoxResourcePath(owner, name));
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not find the resource ", e);
        }
    }

    public List<String> getMessageBoxURISuffixes(String queueNamePrefix) throws MessageBoxException {
        String loggedInUserName = MultitenantUtils.getTenantAwareUsername((String)CarbonContext.getCurrentContext().getUsername());
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            ArrayList<String> messageBoxURISuffixes = new ArrayList<String>();
            if (!Utils.isAdmin(loggedInUserName)) {
                this.addMessageBoxSufixesForUser(loggedInUserName, messageBoxURISuffixes, queueNamePrefix);
            } else {
                Collection userCollection = (Collection)userRegistry.get("message/messageBoxes");
                for (String userName : userCollection.getChildren()) {
                    this.addMessageBoxSufixesForUser(userName.substring(userName.lastIndexOf("/") + 1), messageBoxURISuffixes, queueNamePrefix);
                }
            }
            return messageBoxURISuffixes;
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the registry ", e);
        }
    }

    private void addMessageBoxSufixesForUser(String userName, List<String> messageBoxURISuffixes, String queueNamePrefix) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        UserRegistry userRegistry = Utils.getUserRegistry();
        Collection messageBoxCollection = (Collection)userRegistry.get("message/messageBoxes/" + userName);
        for (String messageBoxPath : messageBoxCollection.getChildren()) {
            String messageBoxName = messageBoxPath.substring(messageBoxPath.lastIndexOf("/") + 1);
            if (!messageBoxName.startsWith(queueNamePrefix)) continue;
            messageBoxURISuffixes.add(userName + "/" + messageBoxPath.substring(messageBoxPath.lastIndexOf("/") + 1));
        }
    }

    public String getMessageBoxResourcePath(String owner, String name) {
        return "message/messageBoxes/" + owner + "/" + name;
    }

    public List<MessageBoxDetails> getMessageBoxDetails() throws MessageBoxException {
        ArrayList<MessageBoxDetails> messageBoxDetailsList = new ArrayList<MessageBoxDetails>();
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            Collection userCollection = (Collection)userRegistry.get("message/messageBoxes");
            for (String userPath : userCollection.getChildren()) {
                String userName = userPath.substring(userPath.lastIndexOf("/") + 1);
                Collection messageBoxCollection = (Collection)userRegistry.get(userPath);
                for (String messageBoxPath : messageBoxCollection.getChildren()) {
                    String messageBoxName = messageBoxPath.substring(messageBoxPath.lastIndexOf("/") + 1);
                    Resource messageBoxResource = userRegistry.get(messageBoxPath);
                    long visibilityTimeOut = Long.parseLong(messageBoxResource.getProperty("VisibilityTimeout"));
                    long createdTimestamp = Long.parseLong(messageBoxResource.getProperty("CreatedTimestamp"));
                    MessageBoxDetails messageBoxDetails = new MessageBoxDetails(messageBoxName, userName, visibilityTimeOut, 0);
                    messageBoxDetails.setCreatedTimeStamp(createdTimestamp);
                    messageBoxDetailsList.add(messageBoxDetails);
                }
            }
            return messageBoxDetailsList;
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the user registry ", e);
        }
    }

    public MessageBoxDetails getMessageBoxDetails(String messageBoxId) throws MessageBoxException {
        try {
            Collection userCollection = (Collection)Utils.getUserRegistry().get("message/messageBoxes/" + messageBoxId);
            String userName = messageBoxId.split("/")[0];
            long visibilityTimeOut = Long.parseLong(userCollection.getProperty("VisibilityTimeout"));
            long createdTimestamp = Long.parseLong(userCollection.getProperty("CreatedTimestamp"));
            MessageBoxDetails messageBoxDetails = new MessageBoxDetails(messageBoxId, userName, visibilityTimeOut, 0);
            messageBoxDetails.setCreatedTimeStamp(createdTimestamp);
            return messageBoxDetails;
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the user registry ", e);
        }
    }

    public void setMessageBoxDetails(String messageBoxId, Map<String, String> attributes) throws MessageBoxException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            Collection userCollection = (Collection)userRegistry.get("message/messageBoxes/" + messageBoxId);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                userCollection.editPropertyValue(entry.getKey().toString(), userCollection.getProperty(entry.getKey().toString()), entry.getValue().toString());
            }
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the user registry ", e);
        }
    }

    public boolean isMessageBoxExists(String messageBoxID) throws MessageBoxException {
        try {
            return Utils.getUserRegistry().resourceExists(this.getMessageBoxResourcePath(messageBoxID));
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not find the resource ", e);
        }
    }

    public String getMessageBoxResourcePath(String messageBoxID) {
        return "message/messageBoxes/" + messageBoxID;
    }

    public void deleteMessageBox(String messageBoxID) throws MessageBoxException {
        String messageBoxResourcePath = this.getMessageBoxResourcePath(messageBoxID);
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            userRegistry.delete(messageBoxResourcePath);
            userRegistry.delete("event/queues/jms/" + messageBoxID.replaceFirst("/", "."));
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the registry", e);
        }
    }

    public void addPermission(String messageBoxId, PermissionLabel permissionLabel) throws MessageBoxException {
        String permissionLabelResourcePath = this.getMessageBoxResourcePath(messageBoxId) + "/" + permissionLabel.getLabelName();
        try {
            StringBuffer sharedUsersString = new StringBuffer();
            for (String sharedUser : permissionLabel.getSharedUsers()) {
                sharedUsersString.append(sharedUser);
                sharedUsersString.append("|");
            }
            StringBuffer operationsString = new StringBuffer();
            for (String operation : permissionLabel.getOperations()) {
                operationsString.append(operation);
                operationsString.append("|");
            }
            UserRegistry userRegistry = Utils.getUserRegistry();
            Resource permissionResource = userRegistry.newResource();
            permissionResource.addProperty("sharedUsers", sharedUsersString.toString());
            permissionResource.addProperty("operations", operationsString.toString());
            userRegistry.put(permissionLabelResourcePath, permissionResource);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the registry", e);
        }
    }

    public void removePermission(String messageBoxId, String permissionLabel) throws MessageBoxException {
        String permissionLabelResourcePath = this.getMessageBoxResourcePath(messageBoxId) + "/" + permissionLabel;
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            userRegistry.delete(permissionLabelResourcePath);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not access the registry", e);
        }
    }

    public List<PermissionLabel> getAllPermissions(String messageBoxId) throws MessageBoxException {
        ArrayList<PermissionLabel> permissionList = new ArrayList<PermissionLabel>();
        String permissionLabelResourcePath = this.getMessageBoxResourcePath(messageBoxId);
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            Collection messageBoxCollection = (Collection)userRegistry.get(permissionLabelResourcePath);
            for (String permissionResource : messageBoxCollection.getChildren()) {
                String[] sharedUsers = userRegistry.get(permissionResource).getProperty("sharedUsers").split("\\|");
                String[] operations = userRegistry.get(permissionResource).getProperty("operations").split("\\|");
                String permissionLabelName = permissionResource.substring(permissionResource.lastIndexOf("/") + 1);
                PermissionLabel permissionLabel = new PermissionLabel(permissionLabelName, Arrays.asList(sharedUsers), Arrays.asList(operations));
                permissionList.add(permissionLabel);
            }
            return permissionList;
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not find resources in the registry", e);
        }
    }

    public PermissionLabel getPermission(String messageBoxId, String permissionLabel) throws MessageBoxException {
        String permissionLabelResourcePath = this.getMessageBoxResourcePath(messageBoxId) + "/" + permissionLabel;
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String[] sharedUsers = userRegistry.get(permissionLabelResourcePath).getProperty("sharedUsers").split("\\|");
            String[] operations = userRegistry.get(permissionLabelResourcePath).getProperty("operations").split("\\|");
            return new PermissionLabel(permissionLabel, Arrays.asList(sharedUsers), Arrays.asList(operations));
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            throw new MessageBoxException("Can not find the resource in " + permissionLabelResourcePath, e);
        }
    }

    public List<String> getSharedUsers(String[] accessKeys) throws MessageBoxException {
        ArrayList<String> sharedUsersList = new ArrayList<String>();
        for (String accessKey : accessKeys) {
            sharedUsersList.add(this.getUserName(accessKey));
        }
        return sharedUsersList;
    }

    private String getUserName(String accessKeyId) throws MessageBoxException {
        try {
            org.wso2.carbon.registry.api.Collection userCollection;
            UserRegistry userRegistry = Utils.getUserRegistry();
            if (userRegistry.resourceExists("/users/access.key.index") && (userCollection = (org.wso2.carbon.registry.api.Collection)userRegistry.get("/users/access.key.index")) != null) {
                return userCollection.getProperty(accessKeyId);
            }
            return null;
        }
        catch (RegistryException e) {
            throw new MessageBoxException("Failed to get secret id of user " + accessKeyId);
        }
    }
}

