/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.qpid;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.PermissionLabel;
import org.wso2.carbon.messagebox.internal.ds.MessageBoxServiceValueHolder;
import org.wso2.carbon.messagebox.internal.utils.Utils;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class MessageBoxAuthorizationHandler {
    private static final Log log = LogFactory.getLog(MessageBoxAuthorizationHandler.class);

    public boolean isAuthorized(String messageBoxId, String operation) throws MessageBoxException {
        String loggedInUser = MultitenantUtils.getTenantAwareUsername((String)CarbonContext.getCurrentContext().getUsername());
        try {
            AuthorizationManager authorizationManager = Utils.getUserRelam().getAuthorizationManager();
            String messageBoxPath = "message/messageBoxes/" + messageBoxId;
            return authorizationManager.isUserAuthorized(loggedInUser, messageBoxPath, operation);
        }
        catch (UserStoreException e) {
            String error = "Failed to check is " + loggedInUser + " authorized to " + operation + " to " + messageBoxId;
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    public boolean isUserAuthorized(String userName, String messageBoxId, String operation) throws MessageBoxException {
        try {
            AuthorizationManager authorizationManager = Utils.getUserRelam().getAuthorizationManager();
            String messageBoxPath = "message/messageBoxes/" + messageBoxId;
            return authorizationManager.isUserAuthorized(userName, messageBoxPath, operation);
        }
        catch (UserStoreException e) {
            String error = "Failed to check is " + userName + " authorized to " + operation + " to " + messageBoxId;
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    public void addPermission(String messageBoxId, PermissionLabel permissionLabel) throws MessageBoxException {
        try {
            AuthorizationManager authorizationManager = Utils.getUserRelam().getAuthorizationManager();
            String messageBoxPath = "message/messageBoxes/" + messageBoxId;
            for (String sharedUser : permissionLabel.getSharedUsers()) {
                UserStoreManager userStoreManager = Utils.getUserRelam().getUserStoreManager();
                if (!userStoreManager.isExistingRole(sharedUser)) {
                    userStoreManager.addRole(sharedUser, new String[]{sharedUser}, (org.wso2.carbon.user.api.Permission[])new Permission[0]);
                }
                for (String operation : permissionLabel.getOperations()) {
                    authorizationManager.authorizeRole(sharedUser, messageBoxPath, operation);
                }
            }
        }
        catch (UserStoreException e) {
            String error = "Failed to add permissions to " + messageBoxId + " with permission label " + permissionLabel.getLabelName();
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    public void allowAllPermissionsToAdminRole(String messageBoxId) throws MessageBoxException {
        try {
            AuthorizationManager authorizationManager = Utils.getUserRelam().getAuthorizationManager();
            String messageBoxPath = "message/messageBoxes/" + messageBoxId;
            String adminRoleName = MessageBoxServiceValueHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
            authorizationManager.authorizeRole(adminRoleName, messageBoxPath, "DeleteMessage");
            authorizationManager.authorizeRole(adminRoleName, messageBoxPath, "ChangeMessageVisibility");
            authorizationManager.authorizeRole(adminRoleName, messageBoxPath, "GetQueueAttributes");
            authorizationManager.authorizeRole(adminRoleName, messageBoxPath, "ReceiveMessage");
            authorizationManager.authorizeRole(adminRoleName, messageBoxPath, "SendMessage");
        }
        catch (UserStoreException e) {
            String error = "Failed to add permissions to admin role for message box " + messageBoxId;
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    public void allowAllPermissionsToUser(String messageBoxId, String user) throws MessageBoxException {
        try {
            UserStoreManager userStoreManager = Utils.getUserRelam().getUserStoreManager();
            if (!userStoreManager.isExistingRole(user)) {
                userStoreManager.addRole(user, new String[]{user}, (org.wso2.carbon.user.api.Permission[])new Permission[0]);
            }
            AuthorizationManager authorizationManager = Utils.getUserRelam().getAuthorizationManager();
            String messageBoxPath = "message/messageBoxes/" + messageBoxId;
            authorizationManager.authorizeRole(user, messageBoxPath, "DeleteMessage");
            authorizationManager.authorizeRole(user, messageBoxPath, "ChangeMessageVisibility");
            authorizationManager.authorizeRole(user, messageBoxPath, "GetQueueAttributes");
            authorizationManager.authorizeRole(user, messageBoxPath, "ReceiveMessage");
            authorizationManager.authorizeRole(user, messageBoxPath, "SendMessage");
        }
        catch (UserStoreException e) {
            String error = "Failed to allow permissions to user " + user + " for message box " + messageBoxId;
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    public void denyAllPermissionsToUser(String messageBoxId, String user) throws MessageBoxException {
        try {
            AuthorizationManager authorizationManager = Utils.getUserRelam().getAuthorizationManager();
            String messageBoxPath = "message/messageBoxes/" + messageBoxId;
            authorizationManager.denyUser(user, messageBoxPath, "DeleteMessage");
            authorizationManager.denyUser(user, messageBoxPath, "ChangeMessageVisibility");
            authorizationManager.denyUser(user, messageBoxPath, "GetQueueAttributes");
            authorizationManager.denyUser(user, messageBoxPath, "ReceiveMessage");
            authorizationManager.denyUser(user, messageBoxPath, "SendMessage");
        }
        catch (UserStoreException e) {
            String error = "Failed to deny permissions to user" + user + " for message box " + messageBoxId;
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }

    public void removePermission(String messageBoxId, PermissionLabel permissionLabel) throws MessageBoxException {
        try {
            AuthorizationManager authorizationManager = Utils.getUserRelam().getAuthorizationManager();
            String messageBoxPath = "message/messageBoxes/" + messageBoxId;
            for (String sharedUser : permissionLabel.getSharedUsers()) {
                for (String operation : permissionLabel.getOperations()) {
                    authorizationManager.clearUserAuthorization(sharedUser, messageBoxPath, operation);
                }
            }
        }
        catch (UserStoreException e) {
            String error = "Failed to clear permissions authorized for " + messageBoxId + " with permission label " + permissionLabel.getLabelName();
            log.error((Object)error);
            throw new MessageBoxException(error, e);
        }
    }
}

