/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.sink.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.UUID;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.subscription.EventDispatcher;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.sink.internal.ds.EventSinkValueHolder;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.SQSMessage;

public class EventSinkDispatcher
implements EventDispatcher {
    private static final Log log = LogFactory.getLog(EventSinkDispatcher.class);

    public void notify(Message message, Subscription subscription) {
        String eventSinkURL = subscription.getEventSinkURL();
        String messageBoxID = eventSinkURL.substring("sqs://".length());
        SQSMessage sqsMessage = new SQSMessage();
        sqsMessage.setBody(message.getMessage().toString());
        sqsMessage.setMessageId(UUID.randomUUID().toString());
        sqsMessage.setReceiptHandle(UUID.randomUUID().toString());
        sqsMessage.setMd5ofMessageBody(this.getMD5OfMessage(sqsMessage.getBody()));
        sqsMessage.setReceivedTimeStamp(Calendar.getInstance().getTimeInMillis());
        sqsMessage.setSenderId(subscription.getOwner());
        try {
            EventSinkValueHolder.getInstance().getMessageBoxService().putMessage(messageBoxID, sqsMessage);
        }
        catch (MessageBoxException e) {
            log.error((Object)"Can not put the message ", (Throwable)e);
        }
    }

    private String getMD5OfMessage(String messageBody) {
        String MD5OfMessage = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(messageBody.getBytes());
            byte[] hash = digest.digest();
            MD5OfMessage = Base64Utils.encode((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)("Failed to get MD5 hash in message " + messageBody));
        }
        return MD5OfMessage;
    }
}

