/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.pool.ReadWriteRunnable;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.server.subscription.Subscription;

class SubFlushRunner
implements ReadWriteRunnable {
    private static final Logger _logger = Logger.getLogger(SubFlushRunner.class);
    private final Subscription _sub;
    private final String _name;
    private static final long ITERATIONS = 10L;

    public SubFlushRunner(Subscription sub) {
        this._sub = sub;
        this._name = "SubFlushRunner-" + this._sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String originalName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this._name);
            boolean complete = false;
            try {
                CurrentActor.set(this._sub.getLogActor());
                complete = this.getQueue().flushSubscription(this._sub, 10L);
            }
            catch (AMQException e) {
                _logger.error((Object)e);
            }
            finally {
                CurrentActor.remove();
            }
            if (!complete && !this._sub.isSuspended()) {
                this.getQueue().execute(this);
            }
        }
        finally {
            Thread.currentThread().setName(originalName);
        }
    }

    private SimpleAMQQueue getQueue() {
        return (SimpleAMQQueue)this._sub.getQueue();
    }

    public boolean isRead() {
        return false;
    }

    public boolean isWrite() {
        return true;
    }
}

