/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.output.amqp0_8;

import java.nio.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.CompositeAMQDataBlock;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.SmallCompositeAMQDataBlock;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.apache.qpid.server.message.AMQMessage;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.output.HeaderPropertiesConverter;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.transport.DeliveryProperties;

public class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private static final MethodRegistry METHOD_REGISTRY = MethodRegistry.getMethodRegistry(ProtocolVersion.v8_0);
    private static final ProtocolVersionMethodConverter PROTOCOL_CONVERTER = METHOD_REGISTRY.getProtocolVersionMethodConverter();
    private final AMQProtocolSession _protocolSession;

    public static ProtocolOutputConverter.Factory getInstanceFactory() {
        return new ProtocolOutputConverter.Factory(){

            public ProtocolOutputConverter newInstance(AMQProtocolSession session) {
                return new ProtocolOutputConverterImpl(session);
            }
        };
    }

    private ProtocolOutputConverterImpl(AMQProtocolSession session) {
        this._protocolSession = session;
    }

    public AMQProtocolSession getProtocolSession() {
        return this._protocolSession;
    }

    public void writeDeliver(QueueEntry entry, int channelId, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        AMQDataBlock deliver = this.createEncodedDeliverFrame(entry, channelId, deliveryTag, consumerTag);
        this.writeMessageDelivery(entry.getMessage(), this.getContentHeaderBody(entry), channelId, deliver);
    }

    private ContentHeaderBody getContentHeaderBody(QueueEntry entry) throws AMQException {
        if (entry.getMessage() instanceof AMQMessage) {
            return ((AMQMessage)entry.getMessage()).getContentHeaderBody();
        }
        MessageTransferMessage message = (MessageTransferMessage)entry.getMessage();
        BasicContentHeaderProperties props = HeaderPropertiesConverter.convert(message);
        ContentHeaderBody chb = new ContentHeaderBody(props, 60);
        chb.bodySize = message.getSize();
        return chb;
    }

    public void writeGetOk(QueueEntry entry, int channelId, long deliveryTag, int queueSize) throws AMQException {
        AMQDataBlock deliver = this.createEncodedGetOkFrame(entry, channelId, deliveryTag, queueSize);
        this.writeMessageDelivery(entry.getMessage(), this.getContentHeaderBody(entry), channelId, deliver);
    }

    private void writeMessageDelivery(MessageContentSource message, ContentHeaderBody chb, int channelId, AMQDataBlock deliver) throws AMQException {
        AMQFrame contentHeader = ContentHeaderBody.createAMQFrame(channelId, chb);
        int bodySize = (int)message.getSize();
        if (bodySize == 0) {
            SmallCompositeAMQDataBlock compositeBlock = new SmallCompositeAMQDataBlock(deliver, contentHeader);
            this.writeFrame(compositeBlock);
        } else {
            int maxBodySize = (int)this.getProtocolSession().getMaxFrameSize() - AMQFrame.getFrameOverhead();
            int capacity = bodySize > maxBodySize ? maxBodySize : bodySize;
            ByteBuffer buf = ByteBuffer.allocate(capacity);
            int writtenSize = 0;
            writtenSize += message.getContent(buf, writtenSize);
            buf.flip();
            AMQFrame firstContentBody = new AMQFrame(channelId, PROTOCOL_CONVERTER.convertToBody(buf));
            AMQDataBlock[] blocks = new AMQDataBlock[]{deliver, contentHeader, firstContentBody};
            CompositeAMQDataBlock compositeBlock = new CompositeAMQDataBlock(blocks);
            this.writeFrame(compositeBlock);
            while (writtenSize < bodySize) {
                buf = ByteBuffer.allocate(capacity);
                writtenSize += message.getContent(buf, writtenSize);
                buf.flip();
                this.writeFrame(new AMQFrame(channelId, PROTOCOL_CONVERTER.convertToBody(buf)));
            }
        }
    }

    private AMQDataBlock createEncodedDeliverFrame(QueueEntry entry, int channelId, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        AMQShortString routingKey;
        AMQShortString exchangeName;
        ServerMessage message;
        if (entry.getMessage() instanceof AMQMessage) {
            message = (AMQMessage)entry.getMessage();
            MessagePublishInfo pb = ((AMQMessage)message).getMessagePublishInfo();
            exchangeName = pb.getExchange();
            routingKey = pb.getRoutingKey();
        } else {
            message = (MessageTransferMessage)entry.getMessage();
            DeliveryProperties delvProps = ((MessageTransferMessage)message).getHeader().get(DeliveryProperties.class);
            exchangeName = delvProps == null || delvProps.getExchange() == null ? null : new AMQShortString(delvProps.getExchange());
            routingKey = delvProps == null || delvProps.getRoutingKey() == null ? null : new AMQShortString(delvProps.getRoutingKey());
        }
        boolean isRedelivered = entry.isRedelivered();
        BasicDeliverBody deliverBody = METHOD_REGISTRY.createBasicDeliverBody(consumerTag, deliveryTag, isRedelivered, exchangeName, routingKey);
        AMQFrame deliverFrame = deliverBody.generateFrame(channelId);
        return deliverFrame;
    }

    private AMQDataBlock createEncodedGetOkFrame(QueueEntry entry, int channelId, long deliveryTag, int queueSize) throws AMQException {
        AMQShortString routingKey;
        AMQShortString exchangeName;
        ServerMessage message;
        if (entry.getMessage() instanceof AMQMessage) {
            message = (AMQMessage)entry.getMessage();
            MessagePublishInfo pb = ((AMQMessage)message).getMessagePublishInfo();
            exchangeName = pb.getExchange();
            routingKey = pb.getRoutingKey();
        } else {
            message = (MessageTransferMessage)entry.getMessage();
            DeliveryProperties delvProps = ((MessageTransferMessage)message).getHeader().get(DeliveryProperties.class);
            exchangeName = delvProps == null || delvProps.getExchange() == null ? null : new AMQShortString(delvProps.getExchange());
            routingKey = delvProps == null || delvProps.getRoutingKey() == null ? null : new AMQShortString(delvProps.getRoutingKey());
        }
        boolean isRedelivered = entry.isRedelivered();
        BasicGetOkBody getOkBody = METHOD_REGISTRY.createBasicGetOkBody(deliveryTag, isRedelivered, exchangeName, routingKey, queueSize);
        AMQFrame getOkFrame = getOkBody.generateFrame(channelId);
        return getOkFrame;
    }

    public byte getProtocolMinorVersion() {
        return this.getProtocolSession().getProtocolMinorVersion();
    }

    public byte getProtocolMajorVersion() {
        return this.getProtocolSession().getProtocolMajorVersion();
    }

    private AMQDataBlock createEncodedReturnFrame(MessagePublishInfo messagePublishInfo, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        BasicReturnBody basicReturnBody = METHOD_REGISTRY.createBasicReturnBody(replyCode, replyText, messagePublishInfo.getExchange(), messagePublishInfo.getRoutingKey());
        AMQFrame returnFrame = basicReturnBody.generateFrame(channelId);
        return returnFrame;
    }

    public void writeReturn(MessagePublishInfo messagePublishInfo, ContentHeaderBody header, MessageContentSource content, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        AMQDataBlock returnFrame = this.createEncodedReturnFrame(messagePublishInfo, channelId, replyCode, replyText);
        this.writeMessageDelivery(content, header, channelId, returnFrame);
    }

    public void writeFrame(AMQDataBlock block) {
        this.getProtocolSession().writeFrame(block);
    }

    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        BasicCancelOkBody basicCancelOkBody = METHOD_REGISTRY.createBasicCancelOkBody(consumerTag);
        this.writeFrame(basicCancelOkBody.generateFrame(channelId));
    }
}

