/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.output;

import java.util.Map;
import org.apache.qpid.AMQPInvalidClassException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageProperties;

public class HeaderPropertiesConverter {
    public static BasicContentHeaderProperties convert(MessageTransferMessage messageTransferMessage) {
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        Header header = messageTransferMessage.getHeader();
        DeliveryProperties deliveryProps = header.get(DeliveryProperties.class);
        MessageProperties messageProps = header.get(MessageProperties.class);
        if (deliveryProps != null) {
            if (deliveryProps.hasDeliveryMode()) {
                props.setDeliveryMode((byte)(deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT ? 2 : 1));
            }
            if (deliveryProps.hasExpiration()) {
                props.setExpiration(deliveryProps.getExpiration());
            }
            if (deliveryProps.hasPriority()) {
                props.setPriority((byte)deliveryProps.getPriority().getValue());
            }
            if (deliveryProps.hasTimestamp()) {
                props.setTimestamp(deliveryProps.getTimestamp());
            }
        }
        if (messageProps != null) {
            if (messageProps.hasAppId()) {
                props.setAppId(new AMQShortString(messageProps.getAppId()));
            }
            if (messageProps.hasContentType()) {
                props.setContentType(messageProps.getContentType());
            }
            if (messageProps.hasCorrelationId()) {
                props.setCorrelationId(new AMQShortString(messageProps.getCorrelationId()));
            }
            if (messageProps.hasContentEncoding()) {
                props.setEncoding(messageProps.getContentEncoding());
            }
            if (messageProps.hasMessageId()) {
                props.setMessageId(messageProps.getMessageId().toString());
            }
            if (messageProps.hasUserId()) {
                props.setUserId(new AMQShortString(messageProps.getUserId()));
            }
            if (messageProps.hasApplicationHeaders()) {
                Map<String, Object> appHeaders = messageProps.getApplicationHeaders();
                FieldTable ft = new FieldTable();
                for (Map.Entry<String, Object> entry : appHeaders.entrySet()) {
                    try {
                        ft.put(new AMQShortString(entry.getKey()), entry.getValue());
                    }
                    catch (AMQPInvalidClassException e) {}
                }
                props.setHeaders(ft);
            }
        }
        return props;
    }
}

