/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.federation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.BridgeConfig;
import org.apache.qpid.server.configuration.BridgeConfigType;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.federation.BrokerLink;
import org.apache.qpid.server.flow.WindowCreditManager;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.MessageMetaData_0_10;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.subscription.Subscription_0_10;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageCreditUnit;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.MessageReject;
import org.apache.qpid.transport.MessageRejectCode;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionException;
import org.apache.qpid.transport.SessionListener;

public class Bridge
implements BridgeConfig {
    private final boolean _durable;
    private final boolean _dynamic;
    private final boolean _queueBridge;
    private final boolean _localSource;
    private final String _source;
    private final String _destination;
    private final String _key;
    private final String _tag;
    private final String _excludes;
    private final BrokerLink _link;
    private UUID _id;
    private long _createTime = System.currentTimeMillis();
    private Session _session;
    private BridgeImpl _delegate;
    private final int _bridgeNo;
    private AutoCommitTransaction _transaction;

    public Bridge(BrokerLink brokerLink, int bridgeNo, boolean durable, boolean dynamic, boolean srcIsQueue, boolean srcIsLocal, String src, String dest, String key, String tag, String excludes) {
        this._link = brokerLink;
        this._bridgeNo = bridgeNo;
        this._durable = durable;
        this._dynamic = dynamic;
        this._queueBridge = srcIsQueue;
        this._localSource = srcIsLocal;
        this._source = src;
        this._destination = dest;
        this._key = key;
        this._tag = tag;
        this._excludes = excludes;
        this._id = brokerLink.getConfigStore().createId();
        this._transaction = new AutoCommitTransaction(this.getVirtualHost().getMessageStore());
        if (dynamic) {
            if (!srcIsLocal && !srcIsQueue) {
                this._delegate = new DynamicExchangeBridge();
            }
        } else {
            this._delegate = srcIsLocal ? (srcIsQueue ? new StaticQueuePushBridge() : new StaticExchangePushBridge()) : (srcIsQueue ? new StaticQueuePullBridge() : new StaticExchangePullBridge());
        }
    }

    public UUID getId() {
        return this._id;
    }

    public BridgeConfigType getConfigType() {
        return BridgeConfigType.getInstance();
    }

    public ConfiguredObject getParent() {
        return this.getLink();
    }

    public boolean isDurable() {
        return this._durable;
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public boolean isQueueBridge() {
        return this._queueBridge;
    }

    public boolean isLocalSource() {
        return this._localSource;
    }

    public String getSource() {
        return this._source;
    }

    public String getDestination() {
        return this._destination;
    }

    public String getKey() {
        return this._key;
    }

    public String getTag() {
        return this._tag;
    }

    public String getExcludes() {
        return this._excludes;
    }

    public BrokerLink getLink() {
        return this._link;
    }

    public Integer getChannelId() {
        return this._session == null ? 0 : this._session.getChannel();
    }

    public int getAckBatching() {
        return 0;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bridge bridge = (Bridge)o;
        if (this._durable != bridge._durable) {
            return false;
        }
        if (this._dynamic != bridge._dynamic) {
            return false;
        }
        if (this._localSource != bridge._localSource) {
            return false;
        }
        if (this._queueBridge != bridge._queueBridge) {
            return false;
        }
        if (this._destination != null ? !this._destination.equals(bridge._destination) : bridge._destination != null) {
            return false;
        }
        if (this._excludes != null ? !this._excludes.equals(bridge._excludes) : bridge._excludes != null) {
            return false;
        }
        if (this._key != null ? !this._key.equals(bridge._key) : bridge._key != null) {
            return false;
        }
        if (this._source != null ? !this._source.equals(bridge._source) : bridge._source != null) {
            return false;
        }
        return !(this._tag != null ? !this._tag.equals(bridge._tag) : bridge._tag != null);
    }

    public int hashCode() {
        int result = this._durable ? 1 : 0;
        result = 31 * result + (this._dynamic ? 1 : 0);
        result = 31 * result + (this._queueBridge ? 1 : 0);
        result = 31 * result + (this._localSource ? 1 : 0);
        result = 31 * result + (this._source != null ? this._source.hashCode() : 0);
        result = 31 * result + (this._destination != null ? this._destination.hashCode() : 0);
        result = 31 * result + (this._key != null ? this._key.hashCode() : 0);
        result = 31 * result + (this._tag != null ? this._tag.hashCode() : 0);
        result = 31 * result + (this._excludes != null ? this._excludes.hashCode() : 0);
        return result;
    }

    public void setSession(Session session) {
        this._session = session;
        this._delegate.setSession(session);
    }

    private long getMessageWindowSize() {
        return 10L;
    }

    VirtualHost getVirtualHost() {
        return this._link.getVirtualHost();
    }

    public void close() {
        this._delegate.close();
        this._session = null;
    }

    private class StaticQueuePushBridge
    implements BridgeImpl,
    SessionListener {
        private AMQQueue _queue;

        private StaticQueuePushBridge() {
        }

        public void setSession(Session session) {
            assert (session instanceof ServerSession);
            session.setSessionListener(this);
            QueueRegistry queueRegistry = Bridge.this.getVirtualHost().getQueueRegistry();
            this._queue = queueRegistry.getQueue(Bridge.this._source);
            WindowCreditManager creditManager = new WindowCreditManager(-1L, Bridge.this.getMessageWindowSize());
            Subscription_0_10 sub = new Subscription_0_10((ServerSession)session, Bridge.this._destination, MessageAcceptMode.NONE, MessageAcquireMode.PRE_ACQUIRED, MessageFlowMode.WINDOW, creditManager, null, null);
            ((ServerSession)session).register(Bridge.this._destination, sub);
            try {
                this._queue.registerSubscription(sub, false);
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
        }

        public void opened(Session session) {
        }

        public void resumed(Session session) {
        }

        public void message(Session ssn, MessageTransfer xfr) {
        }

        public void exception(Session session, SessionException exception) {
        }

        public void closed(Session session) {
        }
    }

    private class StaticExchangePushBridge
    implements BridgeImpl,
    SessionListener {
        private final String _tmpQueueName;
        private AMQQueue _queue;

        private StaticExchangePushBridge() {
            this._tmpQueueName = "bridge_queue_" + Bridge.this._bridgeNo + "_" + Bridge.this._link.getFederationTag();
        }

        public void setSession(Session session) {
            assert (session instanceof ServerSession);
            session.setSessionListener(this);
            ExchangeRegistry exchangeRegistry = Bridge.this.getVirtualHost().getExchangeRegistry();
            Exchange exchange = exchangeRegistry.getExchange(Bridge.this._source);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("qpid.trace.exclude", Bridge.this._link.getFederationTag());
            options.put("qpid.trace.id", Bridge.this._link.getRemoteFederationTag());
            try {
                this._queue = AMQQueueFactory.createAMQQueueImpl(this._tmpQueueName, Bridge.this.isDurable(), Bridge.this._link.getFederationTag(), false, false, Bridge.this.getVirtualHost(), options);
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
            WindowCreditManager creditManager = new WindowCreditManager(-1L, Bridge.this.getMessageWindowSize());
            Subscription_0_10 sub = new Subscription_0_10((ServerSession)session, Bridge.this._destination, MessageAcceptMode.NONE, MessageAcquireMode.PRE_ACQUIRED, MessageFlowMode.WINDOW, creditManager, null, null);
            ((ServerSession)session).register(Bridge.this._destination, sub);
            try {
                this._queue.registerSubscription(sub, true);
                Bridge.this.getVirtualHost().getBindingFactory().addBinding(Bridge.this._key, this._queue, exchange, Collections.<String, Object>emptyMap());
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
        }

        public void opened(Session session) {
        }

        public void resumed(Session session) {
        }

        public void message(Session ssn, MessageTransfer xfr) {
        }

        public void exception(Session session, SessionException exception) {
        }

        public void closed(Session session) {
        }
    }

    private final class DynamicExchangeBridge
    extends AbstractPullBridge
    implements Exchange.BindingListener {
        private final String _tmpQueueName;
        private final ConcurrentMap<Binding, Binding> _bindings;

        private DynamicExchangeBridge() {
            this._tmpQueueName = "bridge_queue_" + Bridge.this._bridgeNo + "_" + Bridge.this._link.getFederationTag();
            this._bindings = new ConcurrentHashMap<Binding, Binding>();
        }

        void onSession() {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("qpid.trace.exclude", Bridge.this._link.getFederationTag());
            options.put("qpid.trace.id", Bridge.this._link.getRemoteFederationTag());
            Bridge.this._session.queueDeclare(this._tmpQueueName, null, options, Option.AUTO_DELETE, Option.EXCLUSIVE);
            Bridge.this._session.sync();
            Map subscribeOptions = Collections.EMPTY_MAP;
            String subName = String.valueOf(Bridge.this._bridgeNo);
            Bridge.this._session.messageSubscribe(this._tmpQueueName, subName, MessageAcceptMode.NONE, MessageAcquireMode.PRE_ACQUIRED, null, 0L, subscribeOptions, new Option[0]);
            Bridge.this._session.sync();
            Bridge.this._session.messageSetFlowMode(subName, MessageFlowMode.WINDOW, new Option[0]);
            Bridge.this._session.messageFlow(subName, MessageCreditUnit.MESSAGE, Bridge.this.getMessageWindowSize(), new Option[0]);
            Bridge.this._session.messageFlow(subName, MessageCreditUnit.BYTE, -1L, new Option[0]);
            Bridge.this._session.sync();
            ExchangeRegistry exchangeRegistry = Bridge.this.getVirtualHost().getExchangeRegistry();
            Exchange exchange = exchangeRegistry.getExchange(Bridge.this._destination);
            exchange.addBindingListener(this);
            Collection<Binding> bindings = exchange.getBindings();
            for (Binding binding : bindings) {
                this.propogateBinding(binding);
            }
        }

        private void propogateBinding(Binding binding) {
            if (this._bindings.putIfAbsent(binding, binding) == null) {
                HashMap<String, Object> arguments = new HashMap<String, Object>(binding.getArguments());
                if (arguments.get("qpid.fed.origin") == null) {
                    arguments.put("qpid.fed.op", "");
                    arguments.put("qpid.fed.origin", Bridge.this._link.getFederationTag());
                    arguments.put("qpid.fed.tags", Bridge.this._link.getFederationTag());
                } else {
                    String tags = (String)arguments.get("qpid.fed.tags");
                    if (tags == null) {
                        tags = Bridge.this._link.getFederationTag();
                    } else {
                        if (Arrays.asList(tags.split(",")).contains(Bridge.this._link.getFederationTag())) {
                            return;
                        }
                        tags = tags + "," + Bridge.this._link.getFederationTag();
                    }
                    arguments.put("qpid.fed.tags", tags);
                }
                Bridge.this._session.exchangeBind(this._tmpQueueName, Bridge.this._source, binding.getBindingKey(), arguments, new Option[0]);
                Bridge.this._session.sync();
            }
        }

        private void propogateBindingRemoval(Binding binding) {
            if (this._bindings.remove(binding) != null) {
                Bridge.this._session.exchangeUnbind(this._tmpQueueName, Bridge.this._source, binding.getBindingKey(), new Option[0]);
            }
        }

        public void bindingAdded(Exchange exchange, Binding binding) {
            this.propogateBinding(binding);
        }

        public void bindingRemoved(Exchange exchange, Binding binding) {
            this.propogateBindingRemoval(binding);
        }

        public void close() {
        }
    }

    private final class StaticQueuePullBridge
    extends AbstractPullBridge {
        private StaticQueuePullBridge() {
        }

        public void onSession() {
            Map subscribeOptions = Collections.EMPTY_MAP;
            String subName = String.valueOf(Bridge.this._bridgeNo);
            Bridge.this._session.messageSubscribe(Bridge.this._source, subName, MessageAcceptMode.NONE, MessageAcquireMode.PRE_ACQUIRED, null, 0L, subscribeOptions, new Option[0]);
            Bridge.this._session.sync();
            Bridge.this._session.messageSetFlowMode(subName, MessageFlowMode.WINDOW, new Option[0]);
            Bridge.this._session.messageFlow(subName, MessageCreditUnit.MESSAGE, Bridge.this.getMessageWindowSize(), new Option[0]);
            Bridge.this._session.messageFlow(subName, MessageCreditUnit.BYTE, -1L, new Option[0]);
        }

        public void close() {
        }
    }

    private final class StaticExchangePullBridge
    extends AbstractPullBridge {
        private final String _tmpQueueName;

        private StaticExchangePullBridge() {
            this._tmpQueueName = "bridge_queue_" + Bridge.this._bridgeNo + "_" + Bridge.this._link.getFederationTag();
        }

        public void onSession() {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("qpid.trace.exclude", Bridge.this._link.getFederationTag());
            options.put("qpid.trace.id", Bridge.this._link.getRemoteFederationTag());
            Bridge.this._session.queueDeclare(this._tmpQueueName, null, options, Option.AUTO_DELETE, Option.EXCLUSIVE);
            Bridge.this._session.sync();
            HashMap<String, Object> bindingArgs = new HashMap<String, Object>();
            Bridge.this._session.exchangeBind(this._tmpQueueName, Bridge.this._source, Bridge.this._key, bindingArgs, new Option[0]);
            Bridge.this._session.sync();
            Map subscribeOptions = Collections.EMPTY_MAP;
            String subName = String.valueOf(Bridge.this._bridgeNo);
            Bridge.this._session.messageSubscribe(this._tmpQueueName, subName, MessageAcceptMode.NONE, MessageAcquireMode.PRE_ACQUIRED, null, 0L, subscribeOptions, new Option[0]);
            Bridge.this._session.sync();
            Bridge.this._session.messageSetFlowMode(subName, MessageFlowMode.WINDOW, new Option[0]);
            Bridge.this._session.messageFlow(subName, MessageCreditUnit.MESSAGE, Bridge.this.getMessageWindowSize(), new Option[0]);
            Bridge.this._session.messageFlow(subName, MessageCreditUnit.BYTE, -1L, new Option[0]);
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractPullBridge
    implements BridgeImpl,
    SessionListener {
        private AbstractPullBridge() {
        }

        @Override
        public final void setSession(Session session) {
            session.setSessionListener(this);
            this.onSession();
        }

        abstract void onSession();

        @Override
        public void message(Session ssn, MessageTransfer xfr) {
            ExchangeRegistry exchangeRegistry = Bridge.this.getVirtualHost().getExchangeRegistry();
            Exchange exchange = exchangeRegistry.getExchange(Bridge.this._destination);
            DeliveryProperties delvProps = null;
            if (xfr.getHeader() != null && (delvProps = xfr.getHeader().get(DeliveryProperties.class)) != null && delvProps.hasTtl() && !delvProps.hasExpiration()) {
                delvProps.setExpiration(System.currentTimeMillis() + delvProps.getTtl());
            }
            MessageMetaData_0_10 messageMetaData = new MessageMetaData_0_10(xfr);
            MessageStore store = Bridge.this.getVirtualHost().getMessageStore();
            StoredMessage<MessageMetaData_0_10> storeMessage = store.addMessage(messageMetaData);
            storeMessage.addContent(0, xfr.getBody());
            storeMessage.flushToStore();
            MessageTransferMessage message = new MessageTransferMessage(storeMessage, ((ServerSession)Bridge.this._session).getReference());
            ArrayList<? extends BaseQueue> queues = exchange.route(message);
            if (queues != null && queues.size() != 0) {
                this.enqueue(message, queues);
            } else if (delvProps == null || !delvProps.hasDiscardUnroutable() || !delvProps.getDiscardUnroutable()) {
                if (xfr.getAcceptMode() == MessageAcceptMode.EXPLICIT) {
                    RangeSet rejects = new RangeSet();
                    rejects.add(xfr.getId());
                    MessageReject reject = new MessageReject(rejects, MessageRejectCode.UNROUTABLE, "Unroutable", new Option[0]);
                    ssn.invoke(reject);
                } else {
                    Exchange alternate = exchange.getAlternateExchange();
                    if (alternate != null && (queues = alternate.route(message)) != null && queues.size() != 0) {
                        this.enqueue(message, queues);
                    }
                }
            }
            ssn.processed(xfr);
        }

        private void enqueue(final ServerMessage message, final ArrayList<? extends BaseQueue> queues) {
            Bridge.this._transaction.enqueue(queues, (EnqueableMessage)message, new ServerTransaction.Action(){
                BaseQueue[] _queues;
                {
                    this._queues = queues.toArray(new BaseQueue[queues.size()]);
                }

                public void postCommit() {
                    for (int i = 0; i < this._queues.length; ++i) {
                        try {
                            this._queues[i].enqueue(message);
                            continue;
                        }
                        catch (AMQException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public void onRollback() {
                }
            });
        }

        @Override
        public void exception(Session session, SessionException exception) {
        }

        @Override
        public void closed(Session session) {
        }

        @Override
        public void opened(Session session) {
        }

        @Override
        public void resumed(Session session) {
        }
    }

    private static interface BridgeImpl {
        public void setSession(Session var1);

        public void close();
    }
}

