/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.configuration.management.ConfigurationManagementMBean;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;
import org.apache.qpid.transport.NetworkDriverConfiguration;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfiguration
extends ConfigurationPlugin
implements SignalHandler {
    protected static final Logger _logger = Logger.getLogger(ServerConfiguration.class);
    public static final int DEFAULT_BUFFER_READ_LIMIT_SIZE = 262144;
    public static final int DEFAULT_BUFFER_WRITE_LIMIT_SIZE = 262144;
    public static final boolean DEFAULT_BROKER_CONNECTOR_PROTECTIO_ENABLED = false;
    public static final String DEFAULT_STATUS_UPDATES = "on";
    public static final String SECURITY_CONFIG_RELOADED = "SECURITY CONFIGURATION RELOADED";
    public static final int DEFAULT_FRAME_SIZE = 65536;
    public static final int DEFAULT_PORT = 5672;
    public static final int DEFAULT_SSL_PORT = 8672;
    public static final long DEFAULT_HOUSEKEEPING_PERIOD = 30000L;
    public static final int DEFAULT_JMXPORT = 8999;
    public static final String QPID_HOME = "QPID_HOME";
    public static final String QPID_WORK = "QPID_WORK";
    public static final String LIB_DIR = "lib";
    public static final String PLUGIN_DIR = "plugins";
    public static final String CACHE_DIR = "cache";
    private Map<String, VirtualHostConfiguration> _virtualHosts = new HashMap<String, VirtualHostConfiguration>();
    private File _configFile;
    private File _vhostsFile;
    private Logger _log = Logger.getLogger(this.getClass());
    private ConfigurationManagementMBean _mbean;
    private static final Map<String, String> envVarMap = new HashMap<String, String>();
    public static final String CONNECTOR_PROTECTIO_ENABLED = "connector.protectio.enabled";
    public static final String CONNECTOR_PROTECTIO_READ_BUFFER_LIMIT_SIZE = "connector.protectio.readBufferLimitSize";
    public static final String CONNECTOR_PROTECTIO_WRITE_BUFFER_LIMIT_SIZE = "connector.protectio.writeBufferLimitSize";
    public static final String MGMT_CUSTOM_REGISTRY_SOCKET = "management.custom-registry-socket";
    public static final String STATUS_UPDATES = "status-updates";
    public static final String ADVANCED_LOCALE = "advanced.locale";

    public ServerConfiguration(File configurationURL) throws ConfigurationException {
        this(ServerConfiguration.parseConfig(configurationURL));
        this._configFile = configurationURL;
        try {
            Signal sig = new Signal("HUP");
            Signal.handle(sig, this);
        }
        catch (Exception e) {
            _logger.info((Object)("Signal HUP not supported for OS: " + System.getProperty("os.name")));
        }
    }

    public ServerConfiguration(Configuration conf) {
        envVarMap.put("QPID_PORT", "connector.port");
        envVarMap.put("QPID_ENABLEDIRECTBUFFERS", "advanced.enableDirectBuffers");
        envVarMap.put("QPID_SSLPORT", "connector.ssl.port");
        envVarMap.put("QPID_NIO", "connector.qpidnio");
        envVarMap.put("QPID_WRITEBIASED", "advanced.useWriteBiasedPool");
        envVarMap.put("QPID_JMXPORT", "management.jmxport");
        envVarMap.put("QPID_FRAMESIZE", "advanced.framesize");
        envVarMap.put("QPID_MSGAUTH", "security.msg-auth");
        envVarMap.put("QPID_AUTOREGISTER", "auto_register");
        envVarMap.put("QPID_MANAGEMENTENABLED", "management.enabled");
        envVarMap.put("QPID_HEARTBEATDELAY", "heartbeat.delay");
        envVarMap.put("QPID_HEARTBEATTIMEOUTFACTOR", "heartbeat.timeoutFactor");
        envVarMap.put("QPID_MAXIMUMMESSAGEAGE", "maximumMessageAge");
        envVarMap.put("QPID_MAXIMUMMESSAGECOUNT", "maximumMessageCount");
        envVarMap.put("QPID_MAXIMUMQUEUEDEPTH", "maximumQueueDepth");
        envVarMap.put("QPID_MAXIMUMMESSAGESIZE", "maximumMessageSize");
        envVarMap.put("QPID_MAXIMUMCHANNELCOUNT", "maximumChannelCount");
        envVarMap.put("QPID_MINIMUMALERTREPEATGAP", "minimumAlertRepeatGap");
        envVarMap.put("QPID_QUEUECAPACITY", "capacity");
        envVarMap.put("QPID_FLOWRESUMECAPACITY", "flowResumeCapacity");
        envVarMap.put("QPID_SOCKETRECEIVEBUFFER", "connector.socketReceiveBuffer");
        envVarMap.put("QPID_SOCKETWRITEBUFFER", "connector.socketWriteBuffer");
        envVarMap.put("QPID_TCPNODELAY", "connector.tcpNoDelay");
        envVarMap.put("QPID_ENABLEPOOLEDALLOCATOR", "advanced.enablePooledAllocator");
        envVarMap.put("QPID_STATUS-UPDATES", STATUS_UPDATES);
        this._configuration = conf;
    }

    public void initialise() throws ConfigurationException {
        this.setConfiguration("", this._configuration);
        this.setupVirtualHosts(this._configuration);
    }

    @Override
    public String[] getElementsProcessed() {
        return new String[]{""};
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
        if (this.getListValue("security.jmx.access").size() > 0) {
            String message = "Validation error : security/jmx/access is no longer a supported element within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
        if (this.getListValue("security.jmx.principal-database").size() > 0) {
            String message = "Validation error : security/jmx/principal-database is no longer a supported element within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
    }

    protected void setupVirtualHosts(Configuration conf) throws ConfigurationException {
        List vhostFiles = conf.getList("virtualhosts");
        Configuration vhostConfig = conf.subset("virtualhosts");
        if (!vhostFiles.isEmpty() && !vhostConfig.subset("virtualhost").isEmpty()) {
            throw new ConfigurationException("Only one of external or embedded virtualhosts configuration allowed.");
        }
        if (vhostFiles.size() > 1) {
            throw new ConfigurationException("Only one external virtualhosts configuration file allowed, multiple filenames found.");
        }
        HierarchicalConfiguration vhostConfiguration = new HierarchicalConfiguration();
        if (!vhostConfig.subset("virtualhost").isEmpty()) {
            vhostConfiguration = vhostConfig;
        } else {
            for (String fileName : vhostFiles) {
                this._vhostsFile = new File(fileName);
                if (!this._vhostsFile.exists()) {
                    throw new ConfigurationException("Virtualhosts file does not exist");
                }
                vhostConfiguration = ServerConfiguration.parseConfig(new File(fileName));
                String defaultVirtualHost = vhostConfiguration.getString("default");
                this._configuration.setProperty("virtualhosts.default", (Object)defaultVirtualHost);
            }
        }
        List hosts = vhostConfiguration.getList("virtualhost.name");
        for (int j = 0; j < hosts.size(); ++j) {
            String name = (String)hosts.get(j);
            VirtualHostConfiguration virtualhost = new VirtualHostConfiguration(name, vhostConfiguration.subset("virtualhost." + name));
            this._virtualHosts.put(virtualhost.getName(), virtualhost);
        }
    }

    private static void substituteEnvironmentVariables(Configuration conf) {
        for (Map.Entry<String, String> var : envVarMap.entrySet()) {
            String val = System.getenv(var.getKey());
            if (val == null) continue;
            conf.setProperty(var.getValue(), (Object)val);
        }
    }

    private static Configuration parseConfig(File file) throws ConfigurationException {
        ConfigurationFactory factory = new ConfigurationFactory();
        factory.setConfigurationFileName(file.getAbsolutePath());
        Configuration conf = factory.getConfiguration();
        Iterator keys = conf.getKeys();
        if (!keys.hasNext()) {
            keys = null;
            conf = ServerConfiguration.flatConfig(file);
        }
        ServerConfiguration.substituteEnvironmentVariables(conf);
        return conf;
    }

    public boolean getStatusUpdatesEnabled() {
        String value = this.getStringValue(STATUS_UPDATES, DEFAULT_STATUS_UPDATES);
        return value.equalsIgnoreCase(DEFAULT_STATUS_UPDATES);
    }

    public Locale getLocale() {
        Locale locale;
        String localeString = this.getStringValue(ADVANCED_LOCALE);
        if (localeString == null) {
            return Locale.getDefault();
        }
        String[] parts = localeString.split("_");
        switch (parts.length) {
            case 1: {
                locale = new Locale(localeString);
                break;
            }
            case 2: {
                locale = new Locale(parts[0], parts[1]);
                break;
            }
            default: {
                StringBuilder variant = new StringBuilder(parts[2]);
                if (parts.length > 3) {
                    for (int index = 3; index < parts.length; ++index) {
                        variant.append('_').append(parts[index]);
                    }
                }
                locale = new Locale(parts[0], parts[1], variant.toString());
            }
        }
        return locale;
    }

    public static final Configuration flatConfig(File file) throws ConfigurationException {
        final MyConfiguration conf = new MyConfiguration();
        conf.addConfiguration((Configuration)new SystemConfiguration(){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        conf.addConfiguration((Configuration)new XMLConfiguration(file){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        return conf;
    }

    public String getConfigurationURL() {
        return this._configFile == null ? "" : this._configFile.getAbsolutePath();
    }

    @Override
    public void handle(Signal arg0) {
        try {
            this.reparseConfigFileSecuritySections();
        }
        catch (ConfigurationException e) {
            _logger.error((Object)"Could not reload configuration file security sections", (Throwable)e);
        }
    }

    public void reparseConfigFileSecuritySections() throws ConfigurationException {
        if (this._configFile != null) {
            Configuration newConfig = ServerConfiguration.parseConfig(this._configFile);
            this.setConfiguration("", newConfig);
            ApplicationRegistry.getInstance().getSecurityManager().configureHostPlugins(this);
            Configuration newVhosts = this._vhostsFile == null ? newConfig.subset("virtualhosts") : ServerConfiguration.parseConfig(this._vhostsFile);
            VirtualHostRegistry vhostRegistry = ApplicationRegistry.getInstance().getVirtualHostRegistry();
            for (String hostName : this._virtualHosts.keySet()) {
                VirtualHost vhost = vhostRegistry.getVirtualHost(hostName);
                Configuration vhostConfig = newVhosts.subset("virtualhost." + hostName);
                vhost.getConfiguration().setConfiguration("virtualhosts.virtualhost", vhostConfig);
                vhost.getSecurityManager().configureGlobalPlugins(this);
                vhost.getSecurityManager().configureHostPlugins(vhost.getConfiguration());
            }
            _logger.warn((Object)SECURITY_CONFIG_RELOADED);
        }
    }

    public String getQpidWork() {
        return System.getProperty(QPID_WORK, System.getProperty("java.io.tmpdir"));
    }

    public String getQpidHome() {
        return System.getProperty(QPID_HOME);
    }

    public void setJMXManagementPort(int mport) {
        this.getConfig().setProperty("management.jmxport", (Object)mport);
    }

    public int getJMXManagementPort() {
        return this.getIntValue("management.jmxport", 8999);
    }

    public boolean getUseCustomRMISocketFactory() {
        return this.getBooleanValue(MGMT_CUSTOM_REGISTRY_SOCKET, true);
    }

    public void setUseCustomRMISocketFactory(boolean bool) {
        this.getConfig().setProperty(MGMT_CUSTOM_REGISTRY_SOCKET, (Object)bool);
    }

    public boolean getPlatformMbeanserver() {
        return this.getBooleanValue("management.platform-mbeanserver", true);
    }

    public String[] getVirtualHosts() {
        return this._virtualHosts.keySet().toArray(new String[this._virtualHosts.size()]);
    }

    public String getPluginDirectory() {
        return this.getStringValue("plugin-directory");
    }

    public String getCacheDirectory() {
        return this.getStringValue("cache-directory");
    }

    public VirtualHostConfiguration getVirtualHostConfig(String name) {
        return this._virtualHosts.get(name);
    }

    public void setVirtualHostConfig(VirtualHostConfiguration config) {
        this._virtualHosts.put(config.getName(), config);
    }

    public List<String> getPrincipalDatabaseNames() {
        return this.getListValue("security.principal-databases.principal-database.name");
    }

    public List<String> getPrincipalDatabaseClass() {
        return this.getListValue("security.principal-databases.principal-database.class");
    }

    public List<String> getPrincipalDatabaseAttributeNames(int index) {
        String name = "security.principal-databases.principal-database(" + index + ")." + "attributes.attribute.name";
        return this.getListValue(name);
    }

    public List<String> getPrincipalDatabaseAttributeValues(int index) {
        String name = "security.principal-databases.principal-database(" + index + ")." + "attributes.attribute.value";
        return this.getListValue(name);
    }

    public int getFrameSize() {
        return this.getIntValue("advanced.framesize", 65536);
    }

    public boolean getProtectIOEnabled() {
        return this.getBooleanValue(CONNECTOR_PROTECTIO_ENABLED, false);
    }

    public int getBufferReadLimit() {
        return this.getIntValue(CONNECTOR_PROTECTIO_READ_BUFFER_LIMIT_SIZE, 262144);
    }

    public int getBufferWriteLimit() {
        return this.getIntValue(CONNECTOR_PROTECTIO_WRITE_BUFFER_LIMIT_SIZE, 262144);
    }

    public boolean getSynchedClocks() {
        return this.getBooleanValue("advanced.synced-clocks");
    }

    public boolean getMsgAuth() {
        return this.getBooleanValue("security.msg-auth");
    }

    public String getManagementKeyStorePath() {
        return this.getStringValue("management.ssl.keyStorePath");
    }

    public boolean getManagementSSLEnabled() {
        return this.getBooleanValue("management.ssl.enabled", true);
    }

    public String getManagementKeyStorePassword() {
        return this.getStringValue("management.ssl.keyStorePassword");
    }

    public boolean getQueueAutoRegister() {
        return this.getBooleanValue("queue.auto_register", true);
    }

    public boolean getManagementEnabled() {
        return this.getBooleanValue("management.enabled", true);
    }

    public void setManagementEnabled(boolean enabled) {
        this.getConfig().setProperty("management.enabled", (Object)enabled);
    }

    public int getHeartBeatDelay() {
        return this.getIntValue("heartbeat.delay", 5);
    }

    public double getHeartBeatTimeout() {
        return this.getDoubleValue("heartbeat.timeoutFactor", 2.0);
    }

    public int getDeliveryPoolSize() {
        return this.getIntValue("delivery.poolsize");
    }

    public long getMaximumMessageAge() {
        return this.getLongValue("maximumMessageAge");
    }

    public long getMaximumMessageCount() {
        return this.getLongValue("maximumMessageCount");
    }

    public long getMaximumQueueDepth() {
        return this.getLongValue("maximumQueueDepth");
    }

    public long getMaximumMessageSize() {
        return this.getLongValue("maximumMessageSize");
    }

    public long getMinimumAlertRepeatGap() {
        return this.getLongValue("minimumAlertRepeatGap");
    }

    public long getCapacity() {
        return this.getLongValue("capacity");
    }

    public long getFlowResumeCapacity() {
        return this.getLongValue("flowResumeCapacity", this.getCapacity());
    }

    public int getProcessors() {
        return this.getIntValue("connector.processors", 4);
    }

    public List getPorts() {
        return this.getListValue("connector.port", Collections.singletonList(5672));
    }

    public List getPortExclude010() {
        return this.getListValue("connector.non010port");
    }

    public List getPortExclude091() {
        return this.getListValue("connector.non091port");
    }

    public List getPortExclude09() {
        return this.getListValue("connector.non09port");
    }

    public List getPortExclude08() {
        return this.getListValue("connector.non08port");
    }

    public String getBind() {
        return this.getStringValue("connector.bind", "wildcard");
    }

    public int getReceiveBufferSize() {
        return this.getIntValue("connector.socketReceiveBuffer", Short.MAX_VALUE);
    }

    public int getWriteBufferSize() {
        return this.getIntValue("connector.socketWriteBuffer", Short.MAX_VALUE);
    }

    public boolean getTcpNoDelay() {
        return this.getBooleanValue("connector.tcpNoDelay", true);
    }

    public boolean getEnableExecutorPool() {
        return this.getBooleanValue("advanced.filterchain[@enableExecutorPool]");
    }

    public boolean getEnableSSL() {
        return this.getBooleanValue("connector.ssl.enabled");
    }

    public boolean getSSLOnly() {
        return this.getBooleanValue("connector.ssl.sslOnly");
    }

    public int getSSLPort() {
        return this.getIntValue("connector.sslport", 8672);
    }

    public String getKeystorePath() {
        return this.getStringValue("connector.ssl.keystorePath", "none");
    }

    public String getKeystorePassword() {
        return this.getStringValue("connector.ssl.keystorePassword", "none");
    }

    public String getCertType() {
        return this.getStringValue("connector.ssl.certType", "SunX509");
    }

    public boolean getQpidNIO() {
        return this.getBooleanValue("connector.qpidnio");
    }

    public boolean getUseBiasedWrites() {
        return this.getBooleanValue("advanced.useWriteBiasedPool");
    }

    public String getDefaultVirtualHost() {
        return this.getStringValue("virtualhosts.default");
    }

    public void setDefaultVirtualHost(String vhost) {
        this.getConfig().setProperty("virtualhosts.default", (Object)vhost);
    }

    public void setHousekeepingExpiredMessageCheckPeriod(long value) {
        this.getConfig().setProperty("housekeeping.expiredMessageCheckPeriod", (Object)value);
    }

    public long getHousekeepingCheckPeriod() {
        return this.getLongValue("housekeeping.checkPeriod", this.getLongValue("housekeeping.expiredMessageCheckPeriod", 30000L));
    }

    public long getStatisticsSamplePeriod() {
        return this.getConfig().getLong("statistics.sample.period", 5000L);
    }

    public boolean isStatisticsGenerationBrokerEnabled() {
        return this.getConfig().getBoolean("statistics.generation.broker", false);
    }

    public boolean isStatisticsGenerationVirtualhostsEnabled() {
        return this.getConfig().getBoolean("statistics.generation.virtualhosts", false);
    }

    public boolean isStatisticsGenerationConnectionsEnabled() {
        return this.getConfig().getBoolean("statistics.generation.connections", false);
    }

    public long getStatisticsReportingPeriod() {
        return this.getConfig().getLong("statistics.reporting.period", 0L);
    }

    public boolean isStatisticsReportResetEnabled() {
        return this.getConfig().getBoolean("statistics.reporting.reset", false);
    }

    public NetworkDriverConfiguration getNetworkConfiguration() {
        return new NetworkDriverConfiguration(){

            public Integer getTrafficClass() {
                return null;
            }

            public Boolean getTcpNoDelay() {
                return ServerConfiguration.this.getBooleanValue("connector.tcpNoDelay", true);
            }

            public Integer getSoTimeout() {
                return null;
            }

            public Integer getSoLinger() {
                return null;
            }

            public Integer getSendBufferSize() {
                return ServerConfiguration.this.getBufferWriteLimit();
            }

            public Boolean getReuseAddress() {
                return null;
            }

            public Integer getReceiveBufferSize() {
                return ServerConfiguration.this.getBufferReadLimit();
            }

            public Boolean getOOBInline() {
                return null;
            }

            public Boolean getKeepAlive() {
                return null;
            }

            public Boolean getIOThrottlingEnabled() {
                return ServerConfiguration.this.getProtectIOEnabled();
            }
        };
    }

    public int getMaxChannelCount() {
        return this.getIntValue("maximumChannelCount", 256);
    }

    public static class MyConfiguration
    extends CompositeConfiguration {
        public String interpolate(String obj) {
            return super.interpolate(obj);
        }
    }
}

