/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.QpidLog4JConfigurator;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.management.ConfigurationManagementMBean;
import org.apache.qpid.server.information.management.ServerInformationMBean;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.GenericActor;
import org.apache.qpid.server.logging.management.LoggingManagementMBean;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.protocol.AMQProtocolEngineFactory;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.ConfigurationFileApplicationRegistry;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.network.mina.MINANetworkDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static Logger _logger;
    private static boolean _standaloneMode;
    private static final String DEFAULT_CONFIG_FILE = "qpid-config.xml";
    public static final String DEFAULT_LOG_CONFIG_FILENAME = "log4j.xml";
    public static final String QPID_HOME = "QPID_HOME";
    private static final int IPV4_ADDRESS_LENGTH = 4;
    private static final char IPV4_LITERAL_SEPARATOR = '.';
    protected final Options options = new Options();
    protected CommandLine commandLine;

    protected Main(String[] args) throws Exception {
        this.setOptions(this.options);
        if (this.parseCommandline(args)) {
            this.execute();
        }
    }

    protected boolean parseCommandline(String[] args) {
        try {
            this.commandLine = new PosixParser().parse(this.options, args);
            return true;
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Qpid", this.options, true);
            return false;
        }
    }

    protected void setOptions(Options options) {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print the version information and exit");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given configuration file");
        OptionBuilder.withLongOpt((String)"config");
        Option configFile = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"port");
        Option port = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"exclude-0-10");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-10 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-10");
        Option exclude0_10 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"exclude-0-9-1");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-9-1 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-9-1");
        Option exclude0_9_1 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"exclude-0-9");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-9 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-9");
        Option exclude0_9 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"exclude-0-8");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-8 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-8");
        Option exclude0_8 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"mport");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified management port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"mport");
        Option mport = OptionBuilder.create((String)"m");
        OptionBuilder.withArgName((String)"bind");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"bind to the specified address. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"bind");
        Option bind = OptionBuilder.create((String)"b");
        OptionBuilder.withArgName((String)"logconfig");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use the specified log4j xml configuration file. By default looks for a file named log4j.xml in the same directory as the configuration file");
        OptionBuilder.withLongOpt((String)"logconfig");
        Option logconfig = OptionBuilder.create((String)"l");
        OptionBuilder.withArgName((String)"logwatch");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"monitor the log file configuration file for changes. Units are seconds. Zero means do not check for changes.");
        OptionBuilder.withLongOpt((String)"logwatch");
        Option logwatchconfig = OptionBuilder.create((String)"w");
        OptionBuilder.withArgName((String)"sslport");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"SSL port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"sslport");
        Option sslport = OptionBuilder.create((String)"s");
        options.addOption(help);
        options.addOption(version);
        options.addOption(configFile);
        options.addOption(logconfig);
        options.addOption(logwatchconfig);
        options.addOption(port);
        options.addOption(exclude0_10);
        options.addOption(exclude0_9_1);
        options.addOption(exclude0_9);
        options.addOption(exclude0_8);
        options.addOption(mport);
        options.addOption(bind);
        options.addOption(sslport);
    }

    protected void execute() throws Exception {
        if (this.commandLine.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Qpid", this.options, true);
        } else if (this.commandLine.hasOption("v")) {
            String ver = QpidProperties.getVersionString();
            StringBuilder protocol = new StringBuilder("AMQP version(s) [major.minor]: ");
            boolean first = true;
            for (ProtocolVersion pv : ProtocolVersion.getSupportedProtocolVersions()) {
                if (first) {
                    first = false;
                } else {
                    protocol.append(", ");
                }
                protocol.append(pv.getMajorVersion()).append('-').append(pv.getMinorVersion());
            }
            System.out.println(ver + " (" + protocol + ")");
        } else {
            try {
                CurrentActor.set(new BrokerActor(new SystemOutMessageLogger()));
                this.startup();
                CurrentActor.remove();
            }
            catch (InitException e) {
                this.shutdown(1);
                throw new Exception(e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.shutdown(1);
                throw new Exception(e.getMessage());
            }
        }
    }

    protected void shutdown(int status) {
        ApplicationRegistry.removeAll();
        if (_standaloneMode) {
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() throws Exception {
        String QpidHome = System.getProperty(QPID_HOME);
        File defaultConfigFile = new File(QpidHome, DEFAULT_CONFIG_FILE);
        File configFile = new File(this.commandLine.getOptionValue("c", defaultConfigFile.getPath()));
        if (!configFile.exists()) {
            String error = "File " + configFile + " could not be found. Check the file exists and is readable.";
            if (QpidHome == null) {
                error = error + "\nNote: " + QPID_HOME + " is not set.";
            }
            throw new InitException(error, null);
        }
        CurrentActor.get().message(BrokerMessages.CONFIG(configFile.getAbsolutePath()));
        String logConfig = this.commandLine.getOptionValue("l");
        String logWatchConfig = this.commandLine.getOptionValue("w", "0");
        int logWatchTime = 0;
        try {
            logWatchTime = Integer.parseInt(logWatchConfig);
        }
        catch (NumberFormatException e) {
            System.err.println("Log watch configuration value of " + logWatchConfig + " is invalid. Must be " + "a non-negative integer. Using default of zero (no watching configured");
        }
        ConfigurationFileApplicationRegistry config = new ConfigurationFileApplicationRegistry(configFile);
        ServerConfiguration serverConfig = config.getConfiguration();
        this.updateManagementPort(serverConfig, this.commandLine.getOptionValue("m"));
        ApplicationRegistry.initialise(config);
        BrokerMessages.reload();
        CurrentActor.set(new BrokerActor(config.getCompositeStartupMessageLogger()));
        CurrentActor.setDefault(new BrokerActor(config.getRootMessageLogger()));
        GenericActor.setDefaultMessageLogger(config.getRootMessageLogger());
        try {
            ConfigurationManagementMBean configMBean = new ConfigurationManagementMBean();
            configMBean.register();
            ServerInformationMBean sysInfoMBean = new ServerInformationMBean(config);
            sysInfoMBean.register();
            String[] portStr = this.commandLine.getOptionValues("p");
            HashSet<Integer> ports = new HashSet<Integer>();
            HashSet<Integer> exclude_0_10 = new HashSet<Integer>();
            HashSet<Integer> exclude_0_9_1 = new HashSet<Integer>();
            HashSet<Integer> exclude_0_9 = new HashSet<Integer>();
            HashSet<Integer> exclude_0_8 = new HashSet<Integer>();
            if (portStr == null || portStr.length == 0) {
                this.parsePortList(ports, serverConfig.getPorts());
                this.parsePortList(exclude_0_10, serverConfig.getPortExclude010());
                this.parsePortList(exclude_0_9_1, serverConfig.getPortExclude091());
                this.parsePortList(exclude_0_9, serverConfig.getPortExclude09());
                this.parsePortList(exclude_0_8, serverConfig.getPortExclude08());
            } else {
                this.parsePortArray(ports, portStr);
                this.parsePortArray(exclude_0_10, this.commandLine.getOptionValues("exclude-0-10"));
                this.parsePortArray(exclude_0_9_1, this.commandLine.getOptionValues("exclude-0-9-1"));
                this.parsePortArray(exclude_0_9, this.commandLine.getOptionValues("exclude-0-9"));
                this.parsePortArray(exclude_0_8, this.commandLine.getOptionValues("exclude-0-8"));
            }
            String bindAddr = this.commandLine.getOptionValue("b");
            if (bindAddr == null) {
                bindAddr = serverConfig.getBind();
            }
            InetAddress bindAddress = null;
            bindAddress = bindAddr.equals("wildcard") ? new InetSocketAddress(0).getAddress() : InetAddress.getByAddress(this.parseIP(bindAddr));
            String hostName = bindAddress.getCanonicalHostName();
            String keystorePath = serverConfig.getKeystorePath();
            String keystorePassword = serverConfig.getKeystorePassword();
            String certType = serverConfig.getCertType();
            SSLContextFactory sslFactory = null;
            if (!serverConfig.getSSLOnly()) {
                Iterator i$ = ports.iterator();
                while (i$.hasNext()) {
                    int port = (Integer)i$.next();
                    MINANetworkDriver driver = new MINANetworkDriver();
                    EnumSet<MultiVersionProtocolEngineFactory.VERSION> supported = EnumSet.allOf(MultiVersionProtocolEngineFactory.VERSION.class);
                    if (exclude_0_10.contains(port)) {
                        supported.remove((Object)MultiVersionProtocolEngineFactory.VERSION.v0_10);
                    }
                    if (exclude_0_9_1.contains(port)) {
                        supported.remove((Object)MultiVersionProtocolEngineFactory.VERSION.v0_9_1);
                    }
                    if (exclude_0_9.contains(port)) {
                        supported.remove((Object)MultiVersionProtocolEngineFactory.VERSION.v0_9);
                    }
                    if (exclude_0_8.contains(port)) {
                        supported.remove((Object)MultiVersionProtocolEngineFactory.VERSION.v0_8);
                    }
                    MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory(hostName, supported);
                    driver.bind(port, new InetAddress[]{bindAddress}, protocolEngineFactory, serverConfig.getNetworkConfiguration(), null);
                    ApplicationRegistry.getInstance().addAcceptor(new InetSocketAddress(bindAddress, port), new QpidAcceptor(driver, "TCP"));
                    CurrentActor.get().message(BrokerMessages.LISTENING("TCP", port));
                }
            }
            if (serverConfig.getEnableSSL()) {
                sslFactory = new SSLContextFactory(keystorePath, keystorePassword, certType);
                MINANetworkDriver driver = new MINANetworkDriver();
                String sslPort = this.commandLine.getOptionValue("s");
                int port = 0;
                port = null != sslPort ? Integer.parseInt(sslPort) : serverConfig.getSSLPort();
                driver.bind(port, new InetAddress[]{bindAddress}, new AMQProtocolEngineFactory(), serverConfig.getNetworkConfiguration(), sslFactory);
                ApplicationRegistry.getInstance().addAcceptor(new InetSocketAddress(bindAddress, port), new QpidAcceptor(driver, "TCP"));
                CurrentActor.get().message(BrokerMessages.LISTENING("TCP/SSL", port));
            }
            CurrentActor.get().message(BrokerMessages.READY());
        }
        finally {
            CurrentActor.remove();
        }
    }

    private void parsePortArray(Set<Integer> ports, String[] portStr) throws InitException {
        if (portStr != null) {
            for (int i = 0; i < portStr.length; ++i) {
                try {
                    ports.add(Integer.parseInt(portStr[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InitException("Invalid port: " + portStr[i], e);
                }
            }
        }
    }

    private void parsePortList(Set<Integer> output, List input) throws InitException {
        if (input != null) {
            for (Object port : input) {
                try {
                    output.add(Integer.parseInt(String.valueOf(port)));
                }
                catch (NumberFormatException e) {
                    throw new InitException("Invalid port: " + port, e);
                }
            }
        }
    }

    private void updateManagementPort(ServerConfiguration configuration, String managementPort) {
        if (managementPort != null) {
            try {
                configuration.setJMXManagementPort(Integer.parseInt(managementPort));
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)("Invalid management port: " + managementPort + " will use:" + configuration.getJMXManagementPort()), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (System.getProperty("log4j.configuration") == null) {
            System.setProperty("log4j.defaultInitOverride", "true");
        }
        _logger = Logger.getLogger(Main.class);
        new Main(args);
    }

    private byte[] parseIP(String address) throws Exception {
        char[] literalBuffer = address.toCharArray();
        int byteCount = 0;
        int currByte = 0;
        byte[] ip = new byte[4];
        for (int i = 0; i < literalBuffer.length; ++i) {
            char currChar = literalBuffer[i];
            if (currChar >= '0' && currChar <= '9') {
                currByte = currByte * 10 + (Character.digit(currChar, 10) & 0xFF);
            }
            if (currChar != '.' && i + 1 != literalBuffer.length) continue;
            ip[byteCount++] = (byte)currByte;
            currByte = 0;
        }
        if (byteCount != 4) {
            throw new Exception("Invalid IP address: " + address);
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogging(File logConfigFile, int logWatchTime) throws InitException, IOException {
        if (logConfigFile.exists() && logConfigFile.canRead()) {
            CurrentActor.get().message(BrokerMessages.LOG_CONFIG(logConfigFile.getAbsolutePath()));
            if (logWatchTime > 0) {
                System.out.println("log file " + logConfigFile.getAbsolutePath() + " will be checked for changes every " + logWatchTime + " seconds");
                try {
                    QpidLog4JConfigurator.configureAndWatch((String)logConfigFile.getPath(), (long)(logWatchTime * 1000));
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            } else {
                try {
                    QpidLog4JConfigurator.configure((String)logConfigFile.getPath());
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            }
        } else {
            System.err.println("Logging configuration error: unable to read file " + logConfigFile.getAbsolutePath());
            System.err.println("Using the fallback internal log4j.properties configuration");
            InputStream propsFile = this.getClass().getResourceAsStream("/log4j.properties");
            if (propsFile == null) {
                throw new IOException("Unable to load the fallback internal log4j.properties configuration file");
            }
            try {
                Properties fallbackProps = new Properties();
                fallbackProps.load(propsFile);
                PropertyConfigurator.configure((Properties)fallbackProps);
            }
            finally {
                propsFile.close();
            }
        }
    }

    private void configureLoggingManagementMBean(File logConfigFile, int logWatchTime) throws Exception {
        LoggingManagementMBean blm = new LoggingManagementMBean(logConfigFile.getPath(), logWatchTime);
        blm.register();
    }

    public static void setStandaloneMode(boolean standaloneMode) {
        _standaloneMode = standaloneMode;
    }

    static {
        _standaloneMode = true;
    }

    protected static class InitException
    extends Exception {
        InitException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

