/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageFactoryRegistry;
import org.apache.qpid.client.message.UnprocessedMessage_0_8;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.filter.JMSSelectorFilter;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.FieldTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMessageConsumer_0_8
extends BasicMessageConsumer<UnprocessedMessage_0_8> {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());

    protected BasicMessageConsumer_0_8(int channelId, AMQConnection connection, AMQDestination destination, String messageSelector, boolean noLocal, MessageFactoryRegistry messageFactory, AMQSession session, AMQProtocolHandler protocolHandler, FieldTable arguments, int prefetchHigh, int prefetchLow, boolean exclusive, int acknowledgeMode, boolean noConsume, boolean autoClose) throws JMSException {
        super(channelId, connection, destination, messageSelector, noLocal, messageFactory, session, protocolHandler, arguments, prefetchHigh, prefetchLow, exclusive, acknowledgeMode, noConsume, autoClose);
        try {
            if (messageSelector != null && messageSelector.length() > 0) {
                JMSSelectorFilter _filter = new JMSSelectorFilter(messageSelector);
            }
        }
        catch (AMQInternalException e) {
            throw new InvalidSelectorException("cannot create consumer because of selector issue");
        }
    }

    @Override
    void sendCancel() throws AMQException, FailoverException {
        BasicCancelBody body = this.getSession().getMethodRegistry().createBasicCancelBody(new AMQShortString(String.valueOf(this._consumerTag)), false);
        AMQFrame cancelFrame = body.generateFrame(this._channelId);
        this._protocolHandler.syncWrite(cancelFrame, BasicCancelOkBody.class);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("CancelOk'd for consumer:" + this.debugIdentity());
        }
    }

    @Override
    public AbstractJMSMessage createJMSMessageFromUnprocessedMessage(AMQMessageDelegateFactory delegateFactory, UnprocessedMessage_0_8 messageFrame) throws Exception {
        return this._messageFactory.createMessage(messageFrame.getDeliveryTag(), messageFrame.isRedelivered(), messageFrame.getExchange(), messageFrame.getRoutingKey(), messageFrame.getContentHeader(), messageFrame.getBodies());
    }

    @Override
    Message receiveBrowse() throws JMSException {
        return this.receive();
    }

    @Override
    void cleanupQueue() throws AMQException, FailoverException {
    }
}

