/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.qpid.ToyExchange;
import org.apache.qpid.transport.Acquired;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.ExchangeBind;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquire;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageFlow;
import org.apache.qpid.transport.MessageFlush;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageRejectCode;
import org.apache.qpid.transport.MessageSubscribe;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.QueueDeclare;
import org.apache.qpid.transport.QueueQuery;
import org.apache.qpid.transport.QueueQueryResult;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.ServerDelegate;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDelegate;
import org.apache.qpid.transport.network.mina.MinaHandler;

class ToyBroker
extends SessionDelegate {
    private ToyExchange exchange;
    private Map<String, Consumer> consumers = new ConcurrentHashMap<String, Consumer>();

    public ToyBroker(ToyExchange exchange) {
        this.exchange = exchange;
    }

    public void messageAcquire(Session context, MessageAcquire struct) {
        System.out.println("\n==================> messageAcquire ");
        context.executionResult(struct.getId(), new Acquired(struct.getTransfers()), new Option[0]);
    }

    public void queueDeclare(Session ssn, QueueDeclare qd) {
        this.exchange.createQueue(qd.getQueue());
        System.out.println("\n==================> declared queue: " + qd.getQueue() + "\n");
    }

    public void exchangeBind(Session ssn, ExchangeBind qb) {
        this.exchange.bindQueue(qb.getExchange(), qb.getBindingKey(), qb.getQueue());
        System.out.println("\n==================> bound queue: " + qb.getQueue() + " with binding key " + qb.getBindingKey() + "\n");
    }

    public void queueQuery(Session ssn, QueueQuery qq) {
        QueueQueryResult result = new QueueQueryResult().queue(qq.getQueue());
        ssn.executionResult(qq.getId(), result, new Option[0]);
    }

    public void messageSubscribe(Session ssn, MessageSubscribe ms) {
        Consumer c = new Consumer();
        c._queueName = ms.getQueue();
        this.consumers.put(ms.getDestination(), c);
        System.out.println("\n==================> message subscribe : " + ms.getDestination() + " queue: " + ms.getQueue() + "\n");
    }

    public void messageFlow(Session ssn, MessageFlow struct) {
        Consumer c = this.consumers.get(struct.getDestination());
        c._credit = struct.getValue();
        System.out.println("\n==================> message flow : " + struct.getDestination() + " credit: " + struct.getValue() + "\n");
    }

    public void messageFlush(Session ssn, MessageFlush struct) {
        System.out.println("\n==================> message flush for consumer : " + struct.getDestination() + "\n");
        this.checkAndSendMessagesToConsumer(ssn, struct.getDestination());
    }

    public void messageTransfer(Session ssn, MessageTransfer xfr) {
        String dest = xfr.getDestination();
        System.out.println("received transfer " + dest);
        Header header = xfr.getHeader();
        DeliveryProperties props = header.get(DeliveryProperties.class);
        if (props != null) {
            System.out.println("received headers routing_key " + props.getRoutingKey());
        }
        MessageProperties mp = header.get(MessageProperties.class);
        System.out.println("MP: " + mp);
        if (mp != null) {
            System.out.println(mp.getApplicationHeaders());
        }
        if (this.exchange.route(dest, props == null ? null : props.getRoutingKey(), xfr)) {
            System.out.println("queued " + xfr);
            this.dispatchMessages(ssn);
        } else if (props == null || !props.getDiscardUnroutable()) {
            RangeSet ranges = new RangeSet();
            ranges.add(xfr.getId());
            ssn.messageReject(ranges, MessageRejectCode.UNROUTABLE, "no such destination", new Option[0]);
        }
        ssn.processed(xfr);
    }

    private void transferMessageToPeer(Session ssn, String dest, MessageTransfer m) {
        System.out.println("\n==================> Transfering message to: " + dest + "\n");
        ssn.messageTransfer(m.getDestination(), MessageAcceptMode.EXPLICIT, MessageAcquireMode.PRE_ACQUIRED, m.getHeader(), m.getBody(), new Option[0]);
    }

    private void dispatchMessages(Session ssn) {
        for (String dest : this.consumers.keySet()) {
            this.checkAndSendMessagesToConsumer(ssn, dest);
        }
    }

    private void checkAndSendMessagesToConsumer(Session ssn, String dest) {
        Consumer c = this.consumers.get(dest);
        LinkedBlockingQueue<MessageTransfer> queue = this.exchange.getQueue(c._queueName);
        MessageTransfer m = queue.poll();
        while (m != null && c._credit > 0L) {
            this.transferMessageToPeer(ssn, dest, m);
            --c._credit;
            m = queue.poll();
        }
    }

    public static final void main(String[] args) throws IOException {
        final ToyExchange exchange = new ToyExchange();
        ServerDelegate delegate = new ServerDelegate(){

            public void init(Connection conn, ProtocolHeader hdr) {
                conn.setSessionFactory(new Connection.SessionFactory(){

                    public Session newSession(Connection conn, Binary name, long expiry) {
                        return new ToyBrokerSession(conn, name, expiry, exchange);
                    }
                });
                super.init(conn, hdr);
            }
        };
        MinaHandler.accept("0.0.0.0", 5672, delegate);
    }

    private static final class ToyBrokerSession
    extends Session {
        public ToyBrokerSession(Connection connection, Binary name, long expiry, ToyExchange exchange) {
            super(connection, new ToyBroker(exchange), name, expiry);
        }
    }

    private static class Consumer {
        long _credit;
        String _queueName;

        private Consumer() {
        }
    }
}

