/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.WriteBufferFullExeception;
import org.apache.mina.filter.executor.ExecutorFilter;

public class WriteBufferLimitFilterBuilder {
    public static final String PENDING_SIZE = WriteBufferLimitFilterBuilder.class.getName() + ".pendingSize";
    private static int DEFAULT_CONNECTION_BUFFER_MESSAGE_COUNT = 5000;
    private volatile boolean throwNotBlock = false;
    private volatile int maximumConnectionBufferCount;
    private volatile long maximumConnectionBufferSize;
    private final Object _blockLock = new Object();
    private int _blockWaiters = 0;

    public WriteBufferLimitFilterBuilder() {
        this(DEFAULT_CONNECTION_BUFFER_MESSAGE_COUNT);
    }

    public WriteBufferLimitFilterBuilder(int maxWriteBufferSize) {
        this.setMaximumConnectionBufferCount(maxWriteBufferSize);
    }

    public void setMaximumConnectionBufferCount(int maximumConnectionBufferCount) {
        this.maximumConnectionBufferCount = maximumConnectionBufferCount;
        this.maximumConnectionBufferSize = 0L;
    }

    public void setMaximumConnectionBufferSize(long maximumConnectionBufferSize) {
        this.maximumConnectionBufferSize = maximumConnectionBufferSize;
        this.maximumConnectionBufferCount = 0;
    }

    public void attach(IoFilterChain chain) {
        String name = this.getThreadPoolFilterEntryName(chain.getAll());
        chain.addBefore(name, this.getClass().getName() + ".sendlimit", new SendLimit());
    }

    public void attach(DefaultIoFilterChainBuilder builder) {
        String name = this.getThreadPoolFilterEntryName(builder.getAll());
        builder.addBefore(name, this.getClass().getName() + ".sendlimit", new SendLimit());
    }

    private String getThreadPoolFilterEntryName(List entries) {
        for (IoFilterChain.Entry entry : entries) {
            if (!entry.getFilter().getClass().isAssignableFrom(ExecutorFilter.class)) continue;
            return entry.getName();
        }
        throw new IllegalStateException("Chain does not contain a ExecutorFilter");
    }

    public class SendLimit
    extends IoFilterAdapter {
        public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
            try {
                this.waitTillSendAllowed(session);
            }
            catch (WriteBufferFullExeception wbfe) {
                nextFilter.exceptionCaught(session, wbfe);
            }
            if (writeRequest.getMessage() instanceof ByteBuffer) {
                this.increasePendingWriteSize(session, (ByteBuffer)writeRequest.getMessage());
            }
            nextFilter.filterWrite(session, writeRequest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void increasePendingWriteSize(IoSession session, ByteBuffer message) {
            IoSession ioSession = session;
            synchronized (ioSession) {
                Long pendingSize = this.getScheduledWriteBytes(session) + (long)message.remaining();
                session.setAttribute(PENDING_SIZE, pendingSize);
            }
        }

        private boolean sendAllowed(IoSession session) {
            if (session.isClosing()) {
                return true;
            }
            int lmswm = WriteBufferLimitFilterBuilder.this.maximumConnectionBufferCount;
            long lmswb = WriteBufferLimitFilterBuilder.this.maximumConnectionBufferSize;
            return !(lmswm != 0 && session.getScheduledWriteRequests() >= lmswm || lmswb != 0L && this.getScheduledWriteBytes(session) >= lmswb);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getScheduledWriteBytes(IoSession session) {
            IoSession ioSession = session;
            synchronized (ioSession) {
                Long i = (Long)session.getAttribute(PENDING_SIZE);
                return null == i ? 0L : i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitTillSendAllowed(IoSession session) {
            Object object = WriteBufferLimitFilterBuilder.this._blockLock;
            synchronized (object) {
                if (WriteBufferLimitFilterBuilder.this.throwNotBlock) {
                    throw new WriteBufferFullExeception();
                }
                WriteBufferLimitFilterBuilder.this._blockWaiters++;
                while (!this.sendAllowed(session)) {
                    try {
                        WriteBufferLimitFilterBuilder.this._blockLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                WriteBufferLimitFilterBuilder.this._blockWaiters--;
            }
        }

        public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            if (message instanceof ByteBuffer) {
                this.decrementPendingWriteSize(session, (ByteBuffer)message);
            }
            this.notifyWaitingWriters();
            nextFilter.messageSent(session, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decrementPendingWriteSize(IoSession session, ByteBuffer message) {
            IoSession ioSession = session;
            synchronized (ioSession) {
                session.setAttribute(PENDING_SIZE, this.getScheduledWriteBytes(session) - (long)message.remaining());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyWaitingWriters() {
            Object object = WriteBufferLimitFilterBuilder.this._blockLock;
            synchronized (object) {
                if (WriteBufferLimitFilterBuilder.this._blockWaiters != 0) {
                    WriteBufferLimitFilterBuilder.this._blockLock.notifyAll();
                }
            }
        }
    }
}

