/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.util.Serial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Range {
    private final int lower;
    private final int upper;

    public Range(int lower, int upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public boolean includes(int value) {
        return Serial.le(this.lower, value) && Serial.le(value, this.upper);
    }

    public boolean includes(Range range) {
        return this.includes(range.lower) && this.includes(range.upper);
    }

    public boolean intersects(Range range) {
        return this.includes(range.lower) || this.includes(range.upper) || range.includes(this.lower) || range.includes(this.upper);
    }

    public boolean touches(Range range) {
        return this.intersects(range) || this.includes(range.upper + 1) || this.includes(range.lower - 1) || range.includes(this.upper + 1) || range.includes(this.lower - 1);
    }

    public Range span(Range range) {
        return new Range(Serial.min(this.lower, range.lower), Serial.max(this.upper, range.upper));
    }

    public List<Range> subtract(Range range) {
        ArrayList<Range> result = new ArrayList<Range>();
        if (this.includes(range.lower) && Serial.le(this.lower, range.lower - 1)) {
            result.add(new Range(this.lower, range.lower - 1));
        }
        if (this.includes(range.upper) && Serial.le(range.upper + 1, this.upper)) {
            result.add(new Range(range.upper + 1, this.upper));
        }
        if (result.isEmpty() && !range.includes(this)) {
            result.add(this);
        }
        return result;
    }

    public Range intersect(Range range) {
        int r;
        int l = Serial.max(this.lower, range.lower);
        if (Serial.gt(l, r = Serial.min(this.upper, range.upper))) {
            return null;
        }
        return new Range(l, r);
    }

    public String toString() {
        return "[" + this.lower + ", " + this.upper + "]";
    }
}

