/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.BindingFactory;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.TransactionLogMessages;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.message.AMQMessage;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.store.ConfigurationRecoveryHandler;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreRecoveryHandler;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.TransactionLog;
import org.apache.qpid.server.store.TransactionLogRecoveryHandler;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class VirtualHostConfigRecoveryHandler
implements ConfigurationRecoveryHandler,
ConfigurationRecoveryHandler.QueueRecoveryHandler,
ConfigurationRecoveryHandler.ExchangeRecoveryHandler,
ConfigurationRecoveryHandler.BindingRecoveryHandler,
MessageStoreRecoveryHandler,
MessageStoreRecoveryHandler.StoredMessageRecoveryHandler,
TransactionLogRecoveryHandler,
TransactionLogRecoveryHandler.QueueEntryRecoveryHandler {
    private static final Logger _logger = Logger.getLogger(VirtualHostConfigRecoveryHandler.class);
    private final VirtualHost _virtualHost;
    private MessageStoreLogSubject _logSubject;
    private List<ProcessAction> _actions;
    private MessageStore _store;
    private TransactionLog _transactionLog;
    private final Map<String, Integer> _queueRecoveries = new TreeMap<String, Integer>();
    private Map<Long, ServerMessage> _recoveredMessages = new HashMap<Long, ServerMessage>();
    private Map<Long, StoredMessage> _unusedMessages = new HashMap<Long, StoredMessage>();

    public VirtualHostConfigRecoveryHandler(VirtualHost virtualHost) {
        this._virtualHost = virtualHost;
    }

    public ConfigurationRecoveryHandler.QueueRecoveryHandler begin(MessageStore store) {
        this._logSubject = new MessageStoreLogSubject(this._virtualHost, store);
        this._store = store;
        CurrentActor.get().message(this._logSubject, TransactionLogMessages.RECOVERY_START(null, false));
        return this;
    }

    public void queue(String queueName, String owner, boolean exclusive, FieldTable arguments) {
        try {
            AMQShortString queueNameShortString = new AMQShortString(queueName);
            AMQQueue q = this._virtualHost.getQueueRegistry().getQueue(queueNameShortString);
            if (q == null) {
                q = AMQQueueFactory.createAMQQueueImpl(queueNameShortString, true, owner == null ? null : new AMQShortString(owner), false, exclusive, this._virtualHost, arguments);
                this._virtualHost.getQueueRegistry().registerQueue(q);
            }
            CurrentActor.get().message(this._logSubject, TransactionLogMessages.RECOVERY_START(queueName, true));
            this._queueRecoveries.put(queueName, 0);
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationRecoveryHandler.ExchangeRecoveryHandler completeQueueRecovery() {
        return this;
    }

    public void exchange(String exchangeName, String type, boolean autoDelete) {
        try {
            AMQShortString exchangeNameSS = new AMQShortString(exchangeName);
            Exchange exchange = this._virtualHost.getExchangeRegistry().getExchange(exchangeNameSS);
            if (exchange == null) {
                exchange = this._virtualHost.getExchangeFactory().createExchange(exchangeNameSS, new AMQShortString(type), true, autoDelete, 0);
                this._virtualHost.getExchangeRegistry().registerExchange(exchange);
            }
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationRecoveryHandler.BindingRecoveryHandler completeExchangeRecovery() {
        return this;
    }

    public MessageStoreRecoveryHandler.StoredMessageRecoveryHandler begin() {
        return this;
    }

    public void message(StoredMessage message) {
        ServerMessage serverMessage;
        switch (message.getMetaData().getType()) {
            case META_DATA_0_8: {
                serverMessage = new AMQMessage(message);
                break;
            }
            case META_DATA_0_10: {
                serverMessage = new MessageTransferMessage(message, null);
                break;
            }
            default: {
                throw new RuntimeException("Unknown message type retrieved from store " + message.getMetaData().getClass());
            }
        }
        this._recoveredMessages.put(message.getMessageNumber(), serverMessage);
        this._unusedMessages.put(message.getMessageNumber(), message);
    }

    public void completeMessageRecovery() {
    }

    public TransactionLogRecoveryHandler.QueueEntryRecoveryHandler begin(TransactionLog log) {
        this._transactionLog = log;
        return this;
    }

    public void binding(String exchangeName, String queueName, String bindingKey, java.nio.ByteBuffer buf) {
        this._actions = new ArrayList<ProcessAction>();
        try {
            Exchange exchange = this._virtualHost.getExchangeRegistry().getExchange(exchangeName);
            if (exchange == null) {
                _logger.error((Object)("Unknown exchange: " + exchangeName + ", cannot bind queue : " + queueName));
                return;
            }
            AMQQueue queue = this._virtualHost.getQueueRegistry().getQueue(new AMQShortString(queueName));
            if (queue == null) {
                _logger.error((Object)("Unknown queue: " + queueName + ", cannot be bound to exchange: " + exchangeName));
            } else {
                Map<String, Object> argumentMap;
                BindingFactory bf;
                FieldTable argumentsFT = null;
                if (buf != null) {
                    argumentsFT = new FieldTable(ByteBuffer.wrap(buf), buf.limit());
                }
                if ((bf = this._virtualHost.getBindingFactory()).getBinding(bindingKey, queue, exchange, argumentMap = FieldTable.convertToMap(argumentsFT)) == null) {
                    _logger.info((Object)("Restoring binding: (Exchange: " + exchange.getNameShortString() + ", Queue: " + queueName + ", Routing Key: " + bindingKey + ", Arguments: " + argumentsFT + ")"));
                    bf.restoreBinding(bindingKey, queue, exchange, argumentMap);
                }
            }
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public void completeBindingRecovery() {
    }

    public void complete() {
    }

    public void queueEntry(final String queueName, long messageId) {
        AMQShortString queueNameShortString = new AMQShortString(queueName);
        AMQQueue queue = this._virtualHost.getQueueRegistry().getQueue(queueNameShortString);
        try {
            if (queue != null) {
                ServerMessage message = this._recoveredMessages.get(messageId);
                this._unusedMessages.remove(messageId);
                if (message != null) {
                    Integer count;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("On recovery, delivering " + message.getMessageNumber() + " to " + queue.getNameShortString()));
                    }
                    if ((count = this._queueRecoveries.get(queueName)) == null) {
                        count = 0;
                    }
                    queue.enqueue(message);
                    count = count + 1;
                    this._queueRecoveries.put(queueName, count);
                } else {
                    _logger.warn((Object)("Message id " + messageId + " referenced in log as enqueued in queue " + queue.getNameShortString() + " is unknown, entry will be discarded"));
                    TransactionLog.Transaction txn = this._transactionLog.newTransaction();
                    txn.dequeueMessage(queue, messageId);
                    txn.commitTranAsync();
                }
            } else {
                _logger.warn((Object)("Message id " + messageId + " in log references queue " + queueName + " which is not in the configuration, entry will be discarded"));
                TransactionLog.Transaction txn = this._transactionLog.newTransaction();
                TransactionLogResource mockQueue = new TransactionLogResource(){

                    public String getResourceName() {
                        return queueName;
                    }
                };
                txn.dequeueMessage(mockQueue, messageId);
                txn.commitTranAsync();
            }
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    public void completeQueueEntryRecovery() {
        for (StoredMessage storedMessage : this._unusedMessages.values()) {
            _logger.warn((Object)("Message id " + storedMessage.getMessageNumber() + " in store, but not in any queue - removing...."));
            storedMessage.remove();
        }
        for (Map.Entry entry : this._queueRecoveries.entrySet()) {
            CurrentActor.get().message(this._logSubject, TransactionLogMessages.RECOVERED((Number)entry.getValue(), (String)entry.getKey()));
            CurrentActor.get().message(this._logSubject, TransactionLogMessages.RECOVERY_COMPLETE((String)entry.getKey(), true));
        }
        CurrentActor.get().message(this._logSubject, TransactionLogMessages.RECOVERY_COMPLETE(null, false));
    }

    private static final class ProcessAction {
        private final AMQQueue _queue;
        private final AMQMessage _message;

        public ProcessAction(AMQQueue queue, AMQMessage message) {
            this._queue = queue;
            this._message = message;
        }

        public void process() {
            try {
                this._queue.enqueue(this._message);
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

