/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.Iterator;
import org.apache.log4j.Logger;

public class CircularBuffer
implements Iterable {
    private static final Logger _logger = Logger.getLogger(CircularBuffer.class);
    private final Object[] _log;
    private int _size;
    private int _index;

    public CircularBuffer(int size) {
        this._log = new Object[size];
    }

    public void add(Object o) {
        this._log[this._index++] = o;
        this._size = Math.min(this._size + 1, this._log.length);
        if (this._index >= this._log.length) {
            this._index = 0;
        }
    }

    public Object get(int i) {
        if (i >= this._log.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this._log[this.index(i)];
    }

    public int size() {
        return this._size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < CircularBuffer.this._size;
            }

            public Object next() {
                return CircularBuffer.this.get(this.i++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (Object o : this) {
            if (!first) {
                s.append(", ");
            } else {
                first = false;
            }
            s.append(o);
        }
        return s.toString();
    }

    public void dump() {
        for (Object o : this) {
            _logger.info(o);
        }
    }

    int index(int i) {
        return this._size == this._log.length ? (this._index + i) % this._log.length : i;
    }

    public static void main(String[] artgv) {
        String[] items = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K"};
        CircularBuffer buffer = new CircularBuffer(5);
        for (String s : items) {
            buffer.add(s);
            _logger.info((Object)buffer);
        }
    }
}

