/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.AMQException;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.configuration.ConnectionConfig;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.GenericActor;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.transport.ServerConnectionDelegate;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnection
extends Connection
implements AMQConnectionModel,
LogSubject {
    private ConnectionConfig _config;
    private Runnable _onOpenTask;
    private AtomicBoolean _logClosed = new AtomicBoolean(false);
    private LogActor _actor = GenericActor.getInstance(this);
    private ApplicationRegistry _registry;
    private boolean _statisticsEnabled = false;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private VirtualHost _virtualHost;

    @Override
    public UUID getId() {
        return this._config.getId();
    }

    @Override
    protected void invoke(Method method) {
        super.invoke(method);
    }

    @Override
    protected void setState(Connection.State state) {
        super.setState(state);
        if (state == Connection.State.OPEN) {
            if (this._onOpenTask != null) {
                this._onOpenTask.run();
            }
            this._actor.message(ConnectionMessages.OPEN(this.getClientId(), "0-10", true, true));
            this.getVirtualHost().getConnectionRegistry().registerConnection(this);
        }
        if ((state == Connection.State.CLOSE_RCVD || state == Connection.State.CLOSED || state == Connection.State.CLOSING) && this._virtualHost != null) {
            this._virtualHost.getConnectionRegistry().deregisterConnection(this);
        }
        if (state == Connection.State.CLOSED) {
            this.logClosed();
        }
    }

    protected void logClosed() {
        if (this._logClosed.compareAndSet(false, true)) {
            CurrentActor.get().message(this, ConnectionMessages.CLOSE());
        }
    }

    @Override
    public ServerConnectionDelegate getConnectionDelegate() {
        return (ServerConnectionDelegate)super.getConnectionDelegate();
    }

    public void setConnectionDelegate(ServerConnectionDelegate delegate) {
        super.setConnectionDelegate(delegate);
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public void setVirtualHost(VirtualHost virtualHost) {
        this._virtualHost = virtualHost;
        this.initialiseStatistics();
    }

    public void setConnectionConfig(ConnectionConfig config) {
        this._config = config;
    }

    public ConnectionConfig getConfig() {
        return this._config;
    }

    public void onOpen(Runnable task) {
        this._onOpenTask = task;
    }

    @Override
    public void closeSession(AMQSessionModel session, AMQConstant cause, String message) throws AMQException {
        ExecutionException ex = new ExecutionException();
        ExecutionErrorCode code = ExecutionErrorCode.INTERNAL_ERROR;
        try {
            code = ExecutionErrorCode.get(cause.getCode());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ex.setErrorCode(code);
        ex.setDescription(message);
        ((ServerSession)session).invoke(ex);
        ((ServerSession)session).close();
    }

    @Override
    public LogSubject getLogSubject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(ProtocolEvent event) {
        if (event.isConnectionControl()) {
            CurrentActor.set(this._actor);
        } else {
            ServerSession channel = (ServerSession)this.getSession(event.getChannel());
            LogActor channelActor = null;
            if (channel != null) {
                channelActor = channel.getLogActor();
            }
            CurrentActor.set(channelActor == null ? this._actor : channelActor);
        }
        try {
            super.received(event);
        }
        finally {
            CurrentActor.remove();
        }
    }

    @Override
    public String toLogString() {
        boolean hasPrincipal;
        boolean hasVirtualHost = null != this.getVirtualHost();
        boolean bl = hasPrincipal = null != this.getAuthorizationID();
        if (hasPrincipal && hasVirtualHost) {
            return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})", this.getConnectionId(), this.getClientId(), this.getConfig().getAddress(), this.getVirtualHost().getName()) + "] ";
        }
        if (hasPrincipal) {
            return "[" + MessageFormat.format("con:{0}({1}@{2})", this.getConnectionId(), this.getClientId(), this.getConfig().getAddress()) + "] ";
        }
        return "[" + MessageFormat.format("con:{0}({1})", this.getConnectionId(), this.getConfig().getAddress()) + "] ";
    }

    public LogActor getLogActor() {
        return this._actor;
    }

    @Override
    public void close(AMQConstant cause, String message) throws AMQException {
        ConnectionCloseCode replyCode = ConnectionCloseCode.NORMAL;
        try {
            replyCode = ConnectionCloseCode.get(cause.getCode());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.close(replyCode, message, new Option[0]);
    }

    @Override
    public List<AMQSessionModel> getSessionModels() {
        ArrayList<AMQSessionModel> sessions = new ArrayList<AMQSessionModel>();
        for (Session ssn : this.getChannels()) {
            sessions.add((AMQSessionModel)((Object)ssn));
        }
        return sessions;
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        if (this.isStatisticsEnabled()) {
            this._messagesDelivered.registerEvent(1L);
            this._dataDelivered.registerEvent(messageSize);
        }
        this._virtualHost.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        if (this.isStatisticsEnabled()) {
            this._messagesReceived.registerEvent(1L, timestamp);
            this._dataReceived.registerEvent(messageSize, timestamp);
        }
        this._virtualHost.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
    }

    @Override
    public void initialiseStatistics() {
        this.setStatisticsEnabled(!StatisticsCounter.DISABLE_STATISTICS && this._virtualHost.getApplicationRegistry().getConfiguration().isStatisticsGenerationConnectionsEnabled());
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getConnectionId());
        this._dataDelivered = new StatisticsCounter("data-delivered-" + this.getConnectionId());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getConnectionId());
        this._dataReceived = new StatisticsCounter("data-received-" + this.getConnectionId());
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this._statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this._statisticsEnabled = enabled;
    }
}

