/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.amqplain;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.FieldTableFactory;

public class AmqPlainSaslServer
implements SaslServer {
    public static final String MECHANISM = "AMQPLAIN";
    private CallbackHandler _cbh;
    private String _authorizationId;
    private boolean _complete = false;

    public AmqPlainSaslServer(CallbackHandler cbh) {
        this._cbh = cbh;
    }

    public String getMechanismName() {
        return MECHANISM;
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            FieldTable ft = FieldTableFactory.newFieldTable(ByteBuffer.wrap(response), response.length);
            String username = ft.getString("LOGIN");
            NameCallback nameCb = new NameCallback("prompt", username);
            PasswordCallback passwordCb = new PasswordCallback("prompt", false);
            String pwd = ft.getString("PASSWORD");
            AuthorizeCallback authzCb = new AuthorizeCallback(username, username);
            Callback[] callbacks = new Callback[]{nameCb, passwordCb, authzCb};
            this._cbh.handle(callbacks);
            String storedPwd = new String(passwordCb.getPassword());
            if (storedPwd.equals(pwd)) {
                this._complete = true;
            }
            if (authzCb.isAuthorized() && this._complete) {
                this._authorizationId = authzCb.getAuthenticationID();
                return null;
            }
            throw new SaslException("Authentication failed");
        }
        catch (AMQFrameDecodingException e) {
            throw new SaslException("Unable to decode response: " + e, e);
        }
        catch (IOException e) {
            throw new SaslException("Error processing data: " + e, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Unable to obtain data from callback handler: " + e, e);
        }
    }

    public boolean isComplete() {
        return this._complete;
    }

    public String getAuthorizationID() {
        return this._authorizationId;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    public void dispose() throws SaslException {
        this._cbh = null;
    }
}

