/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.management;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.apache.qpid.management.common.mbeans.UserManagement;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;

@MBeanDescription(value="User Management Interface")
public class AMQUserManagementMBean
extends AMQManagedObject
implements UserManagement {
    private static final Logger _logger = Logger.getLogger(AMQUserManagementMBean.class);
    private PrincipalDatabase _principalDatabase;
    private static final TabularType _userlistDataType;
    private static final CompositeType _userDataType;

    public AMQUserManagementMBean() throws JMException {
        super(UserManagement.class, "UserManagement");
    }

    public String getObjectInstanceName() {
        return "UserManagement";
    }

    public boolean setPassword(String username, String password) {
        return this.setPassword(username, password.toCharArray());
    }

    public boolean setPassword(String username, char[] password) {
        try {
            return this._principalDatabase.updatePassword(new UsernamePrincipal(username), password);
        }
        catch (AccountNotFoundException e) {
            _logger.warn((Object)("Attempt to set password of non-existent user'" + username + "'"));
            return false;
        }
    }

    public boolean setRights(String username, boolean read, boolean write, boolean admin) {
        throw new UnsupportedOperationException("Support for setting access rights no longer supported.");
    }

    public boolean createUser(String username, String password) {
        return this._principalDatabase.createPrincipal(new UsernamePrincipal(username), password.toCharArray());
    }

    public boolean createUser(String username, String password, boolean read, boolean write, boolean admin) {
        if (read || write || admin) {
            throw new UnsupportedOperationException("Support for setting access rights to true no longer supported.");
        }
        return this.createUser(username, password);
    }

    public boolean createUser(String username, char[] password, boolean read, boolean write, boolean admin) {
        return this.createUser(username, new String(password), read, write, admin);
    }

    public boolean deleteUser(String username) {
        try {
            this._principalDatabase.deletePrincipal(new UsernamePrincipal(username));
        }
        catch (AccountNotFoundException e) {
            _logger.warn((Object)("Attempt to delete user (" + username + ") that doesn't exist"));
            return false;
        }
        return true;
    }

    public boolean reloadData() {
        try {
            this._principalDatabase.reload();
        }
        catch (IOException e) {
            _logger.warn((Object)"Reload failed due to:", (Throwable)e);
            return false;
        }
        return true;
    }

    @MBeanOperation(name="viewUsers", description="All users that are currently available to the system.")
    public TabularData viewUsers() {
        List<Principal> users = this._principalDatabase.getUsers();
        TabularDataSupport userList = new TabularDataSupport(_userlistDataType);
        try {
            for (Principal user : users) {
                Object[] itemData = new Object[]{user.getName(), false, false, false};
                CompositeDataSupport messageData = new CompositeDataSupport(_userDataType, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), itemData);
                userList.put(messageData);
            }
        }
        catch (OpenDataException e) {
            _logger.warn((Object)"Unable to create user list due to :", (Throwable)e);
            return null;
        }
        return userList;
    }

    public void setPrincipalDatabase(PrincipalDatabase database) {
        this._principalDatabase = database;
    }

    static {
        OpenType[] userItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN};
        try {
            _userDataType = new CompositeType("User", "User Data", COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]), userItemTypes);
            _userlistDataType = new TabularType("Users", "List of users", _userDataType, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
        }
        catch (OpenDataException e) {
            _logger.error((Object)"Tabular data setup for viewing users incorrect.", (Throwable)e);
            throw new ExceptionInInitializerError("Tabular data setup for viewing users incorrect");
        }
    }
}

