/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.pool.ReadWriteRunnable;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.queue.SimpleAMQQueue;

public class QueueRunner
implements ReadWriteRunnable {
    private static final Logger _logger = Logger.getLogger(QueueRunner.class);
    private final String _name;
    private final SimpleAMQQueue _queue;

    public QueueRunner(SimpleAMQQueue queue, long count) {
        this._queue = queue;
        this._name = "QueueRunner-" + count + "-" + queue.getLogActor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String originalName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this._name);
            CurrentActor.set(this._queue.getLogActor());
            this._queue.processQueue(this);
        }
        catch (AMQException e) {
            _logger.error((Object)("Exception during asynchronous delivery by " + this._name), (Throwable)e);
        }
        finally {
            CurrentActor.remove();
            Thread.currentThread().setName(originalName);
        }
    }

    public boolean isRead() {
        return false;
    }

    public boolean isWrite() {
        return true;
    }

    public String toString() {
        return this._name;
    }
}

