/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.queue.AMQPriorityQueue;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.ConflationQueue;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQQueueFactory {
    public static final AMQShortString X_QPID_PRIORITIES = new AMQShortString("x-qpid-priorities");
    public static final String QPID_LVQ_KEY = "qpid.LVQ_key";
    public static final String QPID_LAST_VALUE_QUEUE = "qpid.last_value_queue";
    public static final String QPID_LAST_VALUE_QUEUE_KEY = "qpid.last_value_queue_key";
    private static final QueueProperty[] DECLAREABLE_PROPERTIES = new QueueProperty[]{new QueueLongProperty("x-qpid-maximum-message-age"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMaximumMessageAge(value);
        }
    }, new QueueLongProperty("x-qpid-maximum-message-size"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMaximumMessageSize(value);
        }
    }, new QueueLongProperty("x-qpid-maximum-message-count"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMaximumMessageCount(value);
        }
    }, new QueueLongProperty("x-qpid-minimum-alert-repeat-gap"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMinimumAlertRepeatGap(value);
        }
    }, new QueueLongProperty("x-qpid-capacity"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setCapacity(value);
        }
    }, new QueueLongProperty("x-qpid-flow-resume-capacity"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setFlowResumeCapacity(value);
        }
    }};

    public static AMQQueue createAMQQueueImpl(AMQShortString name, boolean durable, AMQShortString owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, FieldTable arguments) throws AMQException {
        return AMQQueueFactory.createAMQQueueImpl(name == null ? null : name.toString(), durable, owner == null ? null : owner.toString(), autoDelete, exclusive, virtualHost, FieldTable.convertToMap(arguments));
    }

    public static AMQQueue createAMQQueueImpl(String queueName, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, Map<String, Object> arguments) throws AMQSecurityException {
        if (!virtualHost.getSecurityManager().authoriseCreateQueue(autoDelete, durable, exclusive, null, null, new AMQShortString(queueName), owner)) {
            String description = "Permission denied: queue-name '" + queueName + "'";
            throw new AMQSecurityException(description);
        }
        int priorities = 1;
        String conflationKey = null;
        if (arguments != null) {
            Object prioritiesObj;
            if (arguments.containsKey(QPID_LAST_VALUE_QUEUE) || arguments.containsKey(QPID_LAST_VALUE_QUEUE_KEY)) {
                conflationKey = (String)arguments.get(QPID_LAST_VALUE_QUEUE_KEY);
                if (conflationKey == null) {
                    conflationKey = QPID_LVQ_KEY;
                }
            } else if (arguments.containsKey(X_QPID_PRIORITIES.toString()) && (prioritiesObj = arguments.get(X_QPID_PRIORITIES.toString())) instanceof Number) {
                priorities = ((Number)prioritiesObj).intValue();
            }
        }
        SimpleAMQQueue q = conflationKey != null ? new ConflationQueue(queueName, durable, owner, autoDelete, exclusive, virtualHost, arguments, conflationKey) : (priorities > 1 ? new AMQPriorityQueue(queueName, durable, owner, autoDelete, exclusive, virtualHost, priorities, arguments) : new SimpleAMQQueue(queueName, durable, owner, autoDelete, exclusive, virtualHost, arguments));
        virtualHost.getQueueRegistry().registerQueue(q);
        q.configure(virtualHost.getConfiguration().getQueueConfiguration(queueName));
        if (arguments != null) {
            for (QueueProperty p : DECLAREABLE_PROPERTIES) {
                if (!arguments.containsKey(p.getArgumentName().toString())) continue;
                p.setPropertyValue(q, arguments.get(p.getArgumentName().toString()));
            }
        }
        return q;
    }

    public static AMQQueue createAMQQueueImpl(QueueConfiguration config, VirtualHost host) throws AMQException {
        String queueName = config.getName();
        boolean durable = config.getDurable();
        boolean autodelete = config.getAutoDelete();
        boolean exclusive = config.getExclusive();
        String owner = config.getOwner();
        HashMap<String, Object> arguments = null;
        if (config.isLVQ() || config.getLVQKey() != null) {
            arguments = new HashMap<String, Object>();
            arguments.put(QPID_LAST_VALUE_QUEUE, 1);
            arguments.put(QPID_LAST_VALUE_QUEUE_KEY, config.getLVQKey() == null ? QPID_LVQ_KEY : config.getLVQKey());
        } else {
            boolean priority = config.getPriority();
            int priorities = config.getPriorities();
            if (priority || priorities > 0) {
                arguments = new HashMap();
                if (priorities < 0) {
                    priorities = 10;
                }
                arguments.put("x-qpid-priorities", priorities);
            }
        }
        AMQQueue q = AMQQueueFactory.createAMQQueueImpl(queueName, durable, owner, autodelete, exclusive, host, arguments);
        q.configure(config);
        return q;
    }

    private static abstract class QueueLongProperty
    extends QueueProperty {
        public QueueLongProperty(String argumentName) {
            super(argumentName);
        }

        public void setPropertyValue(AMQQueue queue, Object value) {
            if (value instanceof Number) {
                this.setPropertyValue(queue, ((Number)value).longValue());
            }
        }

        abstract void setPropertyValue(AMQQueue var1, long var2);
    }

    private static abstract class QueueProperty {
        private final AMQShortString _argumentName;

        public QueueProperty(String argumentName) {
            this._argumentName = new AMQShortString(argumentName);
        }

        public AMQShortString getArgumentName() {
            return this._argumentName;
        }

        public abstract void setPropertyValue(AMQQueue var1, Object var2);
    }
}

