/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.store.MessageMetaDataType;
import org.apache.qpid.server.store.StorableMessageMetaData;

public class MessageMetaData
implements StorableMessageMetaData {
    private MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private int _contentChunkCount;
    private long _arrivalTime;
    private static final byte MANDATORY_FLAG = 1;
    private static final byte IMMEDIATE_FLAG = 2;
    public static final MessageMetaDataType.Factory<MessageMetaData> FACTORY = new MetaDataFactory();

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, int contentChunkCount) {
        this(publishBody, contentHeaderBody, contentChunkCount, System.currentTimeMillis());
    }

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, int contentChunkCount, long arrivalTime) {
        this._contentHeaderBody = contentHeaderBody;
        this._messagePublishInfo = publishBody;
        this._contentChunkCount = contentChunkCount;
        this._arrivalTime = arrivalTime;
    }

    public int getContentChunkCount() {
        return this._contentChunkCount;
    }

    public void setContentChunkCount(int contentChunkCount) {
        this._contentChunkCount = contentChunkCount;
    }

    public ContentHeaderBody getContentHeaderBody() {
        return this._contentHeaderBody;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) {
        this._contentHeaderBody = contentHeaderBody;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public void setMessagePublishInfo(MessagePublishInfo messagePublishInfo) {
        this._messagePublishInfo = messagePublishInfo;
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public void setArrivalTime(long arrivalTime) {
        this._arrivalTime = arrivalTime;
    }

    public MessageMetaDataType getType() {
        return MessageMetaDataType.META_DATA_0_8;
    }

    public int getStorableSize() {
        int size = this._contentHeaderBody.getSize();
        size += 4;
        size += EncodingUtils.encodedShortStringLength(this._messagePublishInfo.getExchange());
        size += EncodingUtils.encodedShortStringLength(this._messagePublishInfo.getRoutingKey());
        ++size;
        return size += EncodingUtils.encodedLongLength();
    }

    public int writeToBuffer(int offset, java.nio.ByteBuffer dest) {
        java.nio.ByteBuffer src = java.nio.ByteBuffer.allocate(this.getStorableSize());
        ByteBuffer minaSrc = ByteBuffer.wrap(src);
        EncodingUtils.writeInteger(minaSrc, this._contentHeaderBody.getSize());
        this._contentHeaderBody.writePayload(minaSrc);
        EncodingUtils.writeShortStringBytes(minaSrc, this._messagePublishInfo.getExchange());
        EncodingUtils.writeShortStringBytes(minaSrc, this._messagePublishInfo.getRoutingKey());
        byte flags = 0;
        if (this._messagePublishInfo.isMandatory()) {
            flags = (byte)(flags | 1);
        }
        if (this._messagePublishInfo.isImmediate()) {
            flags = (byte)(flags | 2);
        }
        EncodingUtils.writeByte(minaSrc, flags);
        EncodingUtils.writeLong(minaSrc, this._arrivalTime);
        src.position(minaSrc.position());
        src.flip();
        src.position(offset);
        src = src.slice();
        if (dest.remaining() < src.limit()) {
            src.limit(dest.remaining());
        }
        dest.put(src);
        return src.limit();
    }

    public int getContentSize() {
        return (int)this._contentHeaderBody.bodySize;
    }

    public boolean isPersistent() {
        BasicContentHeaderProperties properties = (BasicContentHeaderProperties)this._contentHeaderBody.getProperties();
        return properties.getDeliveryMode() == 2;
    }

    public AMQMessageHeader getMessageHeader() {
        return new MessageHeaderAdapter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MessageHeaderAdapter
    implements AMQMessageHeader {
        private MessageHeaderAdapter() {
        }

        private BasicContentHeaderProperties getProperties() {
            return (BasicContentHeaderProperties)MessageMetaData.this.getContentHeaderBody().getProperties();
        }

        @Override
        public String getCorrelationId() {
            return this.getProperties().getCorrelationIdAsString();
        }

        @Override
        public long getExpiration() {
            return this.getProperties().getExpiration();
        }

        @Override
        public String getMessageId() {
            return this.getProperties().getMessageIdAsString();
        }

        @Override
        public String getMimeType() {
            return this.getProperties().getContentTypeAsString();
        }

        @Override
        public String getEncoding() {
            return this.getProperties().getEncodingAsString();
        }

        @Override
        public byte getPriority() {
            return this.getProperties().getPriority();
        }

        @Override
        public long getTimestamp() {
            return this.getProperties().getTimestamp();
        }

        @Override
        public String getType() {
            return this.getProperties().getTypeAsString();
        }

        @Override
        public String getReplyTo() {
            return this.getProperties().getReplyToAsString();
        }

        @Override
        public String getReplyToExchange() {
            return this.getReplyTo();
        }

        @Override
        public String getReplyToRoutingKey() {
            return this.getReplyTo();
        }

        @Override
        public Object getHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.get(name);
        }

        @Override
        public boolean containsHeaders(Set<String> names) {
            FieldTable ft = this.getProperties().getHeaders();
            for (String name : names) {
                if (ft.containsKey(name)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.containsKey(name);
        }
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory {
        private MetaDataFactory() {
        }

        public MessageMetaData createMetaData(java.nio.ByteBuffer buf) {
            try {
                ByteBuffer minaSrc = ByteBuffer.wrap(buf);
                int size = EncodingUtils.readInteger(minaSrc);
                ContentHeaderBody chb = ContentHeaderBody.createFromBuffer(minaSrc, size);
                final AMQShortString exchange = EncodingUtils.readAMQShortString(minaSrc);
                final AMQShortString routingKey = EncodingUtils.readAMQShortString(minaSrc);
                final byte flags = EncodingUtils.readByte(minaSrc);
                long arrivalTime = EncodingUtils.readLong(minaSrc);
                MessagePublishInfo publishBody = new MessagePublishInfo(){

                    public AMQShortString getExchange() {
                        return exchange;
                    }

                    public void setExchange(AMQShortString exchange2) {
                    }

                    public boolean isImmediate() {
                        return (flags & 2) != 0;
                    }

                    public boolean isMandatory() {
                        return (flags & 1) != 0;
                    }

                    public AMQShortString getRoutingKey() {
                        return routingKey;
                    }
                };
                return new MessageMetaData(publishBody, chb, 0, arrivalTime);
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

