/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.QueueUnbindOkBody;
import org.apache.qpid.framing.amqp_0_9.MethodRegistry_0_9;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueUnbindHandler
implements StateAwareMethodListener<QueueUnbindBody> {
    private static final Logger _log = Logger.getLogger(QueueUnbindHandler.class);
    private static final QueueUnbindHandler _instance = new QueueUnbindHandler();

    public static QueueUnbindHandler getInstance() {
        return _instance;
    }

    private QueueUnbindHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueUnbindBody body, int channelId) throws AMQException {
        AMQShortString routingKey;
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (body.getQueue() == null) {
            AMQChannel channel = session.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
            if (queue == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No default queue defined on channel and queue was null");
            }
            routingKey = body.getRoutingKey() == null ? null : body.getRoutingKey().intern();
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
            AMQShortString aMQShortString = routingKey = body.getRoutingKey() == null ? null : body.getRoutingKey().intern();
        }
        if (queue == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
        }
        Exchange exch = exchangeRegistry.getExchange(body.getExchange());
        if (exch == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Exchange " + body.getExchange() + " does not exist.");
        }
        if (virtualHost.getBindingFactory().getBinding(String.valueOf(routingKey), queue, exch, FieldTable.convertToMap(body.getArguments())) == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "No such binding");
        }
        virtualHost.getBindingFactory().removeBinding(String.valueOf(routingKey), queue, exch, FieldTable.convertToMap(body.getArguments()));
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding queue " + queue + " to exchange " + exch + " with routing key " + routingKey));
        }
        MethodRegistry_0_9 methodRegistry = (MethodRegistry_0_9)session.getMethodRegistry();
        QueueUnbindOkBody responseBody = methodRegistry.createQueueUnbindOkBody();
        session.writeFrame(responseBody.generateFrame(channelId));
    }
}

