/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.BasicRecoverBody;
import org.apache.qpid.framing.BasicRecoverOkBody;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.amqp_8_0.MethodRegistry_8_0;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRecoverMethodHandler
implements StateAwareMethodListener<BasicRecoverBody> {
    private static final Logger _logger = Logger.getLogger(BasicRecoverMethodHandler.class);
    private static final BasicRecoverMethodHandler _instance = new BasicRecoverMethodHandler();

    public static BasicRecoverMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicRecoverBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.debug((Object)("Recover received on protocol session " + session + " and channel " + channelId));
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.resend(body.getRequeue());
        if (session.getProtocolVersion().equals(ProtocolVersion.v8_0)) {
            MethodRegistry_8_0 methodRegistry = (MethodRegistry_8_0)session.getMethodRegistry();
            BasicRecoverOkBody recoverOk = methodRegistry.createBasicRecoverOkBody();
            session.writeFrame(recoverOk.generateFrame(channelId));
        }
    }
}

