/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.PropertyExpression;
import org.apache.qpid.server.filter.XPathExpression;
import org.apache.qpid.server.filter.XQueryExpression;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnaryExpression
implements Expression {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression right;

    public static Expression createNegate(Expression left) {
        return new NegativeExpression(left);
    }

    public static BooleanExpression createInExpression(PropertyExpression right, List elements, boolean not) {
        Collection t = elements.size() == 0 ? null : (elements.size() < 5 ? elements : new HashSet(elements));
        List inList = t;
        return new InExpression(right, inList, not);
    }

    public static <E extends Exception> BooleanExpression createNOT(BooleanExpression left) {
        return new NotExpression(left);
    }

    public static BooleanExpression createXPath(String xpath) {
        return new XPathExpression(xpath);
    }

    public static BooleanExpression createXQuery(String xpath) {
        return new XQueryExpression(xpath);
    }

    public static <E extends Exception> BooleanExpression createBooleanCast(Expression left) {
        return new BooleanCastExpression(left);
    }

    private static Number negate(Number left) {
        Class<?> clazz = left.getClass();
        if (clazz == Integer.class) {
            return -left.intValue();
        }
        if (clazz == Long.class) {
            return -left.longValue();
        }
        if (clazz == Float.class) {
            return Float.valueOf(-left.floatValue());
        }
        if (clazz == Double.class) {
            return -left.doubleValue();
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)left;
            if (BD_LONG_MIN_VALUE.compareTo(bd = bd.negate()) == 0) {
                return Long.MIN_VALUE;
            }
            return bd;
        }
        throw new RuntimeException("Don't know how to negate: " + left);
    }

    public UnaryExpression(Expression left) {
        this.right = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.toString().equals(o.toString());
    }

    public abstract String getExpressionSymbol();

    private static class BooleanCastExpression
    extends BooleanUnaryExpression {
        public BooleanCastExpression(Expression left) {
            super(left);
        }

        public Object evaluate(Filterable message) {
            Object rvalue = this.right.evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (!rvalue.getClass().equals(Boolean.class)) {
                return Boolean.FALSE;
            }
            return (Boolean)rvalue != false ? Boolean.TRUE : Boolean.FALSE;
        }

        public String toString() {
            return this.right.toString();
        }

        public String getExpressionSymbol() {
            return "";
        }
    }

    private static class NotExpression
    extends BooleanUnaryExpression {
        public NotExpression(BooleanExpression left) {
            super(left);
        }

        public Object evaluate(Filterable message) {
            Boolean lvalue = (Boolean)this.right.evaluate(message);
            if (lvalue == null) {
                return null;
            }
            return lvalue != false ? Boolean.FALSE : Boolean.TRUE;
        }

        public String getExpressionSymbol() {
            return "NOT";
        }
    }

    private static class InExpression
    extends BooleanUnaryExpression {
        private final Collection _inList;
        private final boolean _not;

        public InExpression(PropertyExpression right, Collection inList, boolean not) {
            super(right);
            this._inList = inList;
            this._not = not;
        }

        public Object evaluate(Filterable message) {
            Object rvalue = this.right.evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (rvalue.getClass() != String.class) {
                return null;
            }
            if ((this._inList != null && this._inList.contains(rvalue)) ^ this._not) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String toString() {
            StringBuffer answer = new StringBuffer();
            answer.append(this.right);
            answer.append(" ");
            answer.append(this.getExpressionSymbol());
            answer.append(" ( ");
            int count = 0;
            for (Object o : this._inList) {
                if (count != 0) {
                    answer.append(", ");
                }
                answer.append(o);
                ++count;
            }
            answer.append(" )");
            return answer.toString();
        }

        public String getExpressionSymbol() {
            if (this._not) {
                return "NOT IN";
            }
            return "IN";
        }
    }

    private static class NegativeExpression
    extends UnaryExpression {
        public NegativeExpression(Expression left) {
            super(left);
        }

        public Object evaluate(Filterable message) {
            Object rvalue = this.right.evaluate(message);
            if (rvalue == null) {
                return null;
            }
            if (rvalue instanceof Number) {
                return UnaryExpression.negate((Number)rvalue);
            }
            return null;
        }

        public String getExpressionSymbol() {
            return "-";
        }
    }

    static abstract class BooleanUnaryExpression
    extends UnaryExpression
    implements BooleanExpression {
        public BooleanUnaryExpression(Expression left) {
            super(left);
        }

        public boolean matches(Filterable message) {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

