/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.ExchangeConfigType;
import org.apache.qpid.server.exchange.AbstractExchangeMBean;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.logging.subjects.ExchangeLogSubject;
import org.apache.qpid.server.management.Managable;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExchange
implements Exchange,
Managable {
    private AMQShortString _name;
    private final AtomicBoolean _closed = new AtomicBoolean();
    private Exchange _alternateExchange;
    protected boolean _durable;
    protected int _ticket;
    private VirtualHost _virtualHost;
    private final List<Exchange.Task> _closeTaskList = new CopyOnWriteArrayList<Exchange.Task>();
    protected AbstractExchangeMBean _exchangeMbean;
    protected boolean _autoDelete;
    private LogSubject _logSubject;
    private Map<ExchangeReferrer, Object> _referrers = new ConcurrentHashMap<ExchangeReferrer, Object>();
    private final CopyOnWriteArrayList<Binding> _bindings = new CopyOnWriteArrayList();
    private final ExchangeType<? extends Exchange> _type;
    private UUID _id;
    private final AtomicInteger _bindingCountHigh = new AtomicInteger();
    private final AtomicLong _receivedMessageCount = new AtomicLong();
    private final AtomicLong _receivedMessageSize = new AtomicLong();
    private final AtomicLong _routedMessageCount = new AtomicLong();
    private final AtomicLong _routedMessageSize = new AtomicLong();
    private final CopyOnWriteArrayList<Exchange.BindingListener> _listeners = new CopyOnWriteArrayList();
    private long _createTime = System.currentTimeMillis();

    public AbstractExchange(ExchangeType<? extends Exchange> type) {
        this._type = type;
    }

    @Override
    public AMQShortString getNameShortString() {
        return this._name;
    }

    @Override
    public final AMQShortString getTypeShortString() {
        return this._type.getName();
    }

    protected abstract AbstractExchangeMBean createMBean() throws JMException;

    @Override
    public void initialise(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
        this._virtualHost = host;
        this._name = name;
        this._durable = durable;
        this._autoDelete = autoDelete;
        this._ticket = ticket;
        this._id = this.getConfigStore().createId();
        this.getConfigStore().addConfiguredObject(this);
        try {
            this._exchangeMbean = this.createMBean();
            this._exchangeMbean.register();
        }
        catch (JMException e) {
            this.getLogger().error((Object)e);
        }
        this._logSubject = new ExchangeLogSubject(this, this.getVirtualHost());
        CurrentActor.get().message(ExchangeMessages.CREATED(String.valueOf(this.getTypeShortString()), String.valueOf(name), durable));
    }

    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    public abstract Logger getLogger();

    @Override
    public boolean isDurable() {
        return this._durable;
    }

    @Override
    public boolean isAutoDelete() {
        return this._autoDelete;
    }

    @Override
    public int getTicket() {
        return this._ticket;
    }

    @Override
    public void close() throws AMQException {
        if (this._closed.compareAndSet(false, true)) {
            if (this._exchangeMbean != null) {
                this._exchangeMbean.unregister();
            }
            this.getConfigStore().removeConfiguredObject(this);
            if (this._alternateExchange != null) {
                this._alternateExchange.removeReference(this);
            }
            CurrentActor.get().message(this._logSubject, ExchangeMessages.DELETED());
            for (Exchange.Task task : this._closeTaskList) {
                task.onClose(this);
            }
            this._closeTaskList.clear();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getNameShortString() + "]";
    }

    @Override
    public ManagedObject getManagedObject() {
        return this._exchangeMbean;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public QueueRegistry getQueueRegistry() {
        return this.getVirtualHost().getQueueRegistry();
    }

    public boolean isBound(String bindingKey, Map<String, Object> arguments, AMQQueue queue) {
        return this.isBound(new AMQShortString(bindingKey), queue);
    }

    @Override
    public boolean isBound(String bindingKey, AMQQueue queue) {
        return this.isBound(new AMQShortString(bindingKey), queue);
    }

    @Override
    public boolean isBound(String bindingKey) {
        return this.isBound(new AMQShortString(bindingKey));
    }

    @Override
    public Exchange getAlternateExchange() {
        return this._alternateExchange;
    }

    @Override
    public void setAlternateExchange(Exchange exchange) {
        if (this._alternateExchange != null) {
            this._alternateExchange.removeReference(this);
        }
        if (exchange != null) {
            exchange.addReference(this);
        }
        this._alternateExchange = exchange;
    }

    @Override
    public void removeReference(ExchangeReferrer exchange) {
        this._referrers.remove(exchange);
    }

    @Override
    public void addReference(ExchangeReferrer exchange) {
        this._referrers.put(exchange, Boolean.TRUE);
    }

    @Override
    public boolean hasReferrers() {
        return !this._referrers.isEmpty();
    }

    @Override
    public void addCloseTask(Exchange.Task task) {
        this._closeTaskList.add(task);
    }

    @Override
    public void removeCloseTask(Exchange.Task task) {
        this._closeTaskList.remove(task);
    }

    @Override
    public final void addBinding(Binding binding) {
        int maxBindingsSize;
        this._bindings.add(binding);
        int bindingCountSize = this._bindings.size();
        while ((maxBindingsSize = this._bindingCountHigh.get()) < bindingCountSize) {
            this._bindingCountHigh.compareAndSet(maxBindingsSize, bindingCountSize);
        }
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingAdded(this, binding);
        }
        this.onBind(binding);
    }

    @Override
    public long getBindingCountHigh() {
        return this._bindingCountHigh.get();
    }

    @Override
    public final void removeBinding(Binding binding) {
        this.onUnbind(binding);
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingRemoved(this, binding);
        }
        this._bindings.remove(binding);
    }

    @Override
    public final Collection<Binding> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    protected abstract void onBind(Binding var1);

    protected abstract void onUnbind(Binding var1);

    @Override
    public String getName() {
        return this._name.toString();
    }

    @Override
    public ExchangeType getType() {
        return this._type;
    }

    @Override
    public Map<String, Object> getArguments() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public ExchangeConfigType getConfigType() {
        return ExchangeConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this._virtualHost;
    }

    @Override
    public long getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public final ArrayList<? extends BaseQueue> route(InboundMessage message) {
        this._receivedMessageCount.incrementAndGet();
        this._receivedMessageSize.addAndGet(message.getSize());
        ArrayList<? extends BaseQueue> queues = this.doRoute(message);
        if (queues != null && !queues.isEmpty()) {
            this._routedMessageCount.incrementAndGet();
            this._routedMessageSize.addAndGet(message.getSize());
        }
        return queues;
    }

    protected abstract ArrayList<? extends BaseQueue> doRoute(InboundMessage var1);

    @Override
    public long getMsgReceives() {
        return this._receivedMessageCount.get();
    }

    @Override
    public long getMsgRoutes() {
        return this._routedMessageCount.get();
    }

    @Override
    public long getByteReceives() {
        return this._receivedMessageSize.get();
    }

    @Override
    public long getByteRoutes() {
        return this._routedMessageSize.get();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void addBindingListener(Exchange.BindingListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeBindingListener(Exchange.BindingListener listener) {
        this._listeners.remove(listener);
    }
}

