/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;

public class QueueConfiguration
extends ConfigurationPlugin {
    private String _name;
    private VirtualHostConfiguration _vHostConfig;

    public QueueConfiguration(String name, VirtualHostConfiguration virtualHostConfiguration) throws ConfigurationException {
        this._vHostConfig = virtualHostConfiguration;
        this._name = name;
        CompositeConfiguration mungedConf = new CompositeConfiguration();
        mungedConf.addConfiguration(this._vHostConfig.getConfig().subset("queues.queue." + name));
        mungedConf.addConfiguration(this._vHostConfig.getConfig().subset("queues"));
        this.setConfiguration("virtualhosts.virtualhost.queues.queue", (Configuration)mungedConf);
    }

    public String[] getElementsProcessed() {
        return new String[]{"maximumMessageSize", "maximumQueueDepth", "maximumMessageCount", "maximumMessageAge", "minimumAlertRepeatGap", "durable", "exchange", "exclusive", "queue", "autodelete", "priority", "priorities", "routingKey", "capacity", "flowResumeCapacity", "lvq", "lvqKey"};
    }

    public void validateConfiguration() throws ConfigurationException {
    }

    public VirtualHostConfiguration getVirtualHostConfiguration() {
        return this._vHostConfig;
    }

    public boolean getDurable() {
        return this.getBooleanValue("durable");
    }

    public boolean getExclusive() {
        return this.getBooleanValue("exclusive");
    }

    public boolean getAutoDelete() {
        return this.getBooleanValue("autodelete");
    }

    public String getOwner() {
        return this.getStringValue("owner", null);
    }

    public boolean getPriority() {
        return this.getBooleanValue("priority");
    }

    public int getPriorities() {
        return this.getIntValue("priorities", -1);
    }

    public String getExchange() {
        return this.getStringValue("exchange", ExchangeDefaults.DEFAULT_EXCHANGE_NAME.asString());
    }

    public List getRoutingKeys() {
        return this.getListValue("routingKey");
    }

    public String getName() {
        return this._name;
    }

    public int getMaximumMessageAge() {
        return this.getIntValue("maximumMessageAge", this._vHostConfig.getMaximumMessageAge());
    }

    public long getMaximumQueueDepth() {
        return this.getLongValue("maximumQueueDepth", this._vHostConfig.getMaximumQueueDepth());
    }

    public long getMaximumMessageSize() {
        return this.getLongValue("maximumMessageSize", this._vHostConfig.getMaximumMessageSize());
    }

    public long getMaximumMessageCount() {
        return this.getLongValue("maximumMessageCount", this._vHostConfig.getMaximumMessageCount());
    }

    public long getMinimumAlertRepeatGap() {
        return this.getLongValue("minimumAlertRepeatGap", this._vHostConfig.getMinimumAlertRepeatGap());
    }

    public long getCapacity() {
        return this.getLongValue("capacity", this._vHostConfig.getCapacity());
    }

    public long getFlowResumeCapacity() {
        return this.getLongValue("flowResumeCapacity", this._vHostConfig.getFlowResumeCapacity());
    }

    public boolean isLVQ() {
        return this.getBooleanValue("lvq");
    }

    public String getLVQKey() {
        return this.getStringValue("lvqKey", null);
    }

    public static class QueueConfig
    extends ConfigurationPlugin {
        public String[] getElementsProcessed() {
            return new String[]{"name"};
        }

        public String getName() {
            return this.getStringValue("name");
        }

        public void validateConfiguration() throws ConfigurationException {
            if (this._configuration.isEmpty()) {
                throw new ConfigurationException("Queue section cannot be empty.");
            }
            if (this.getName() == null) {
                throw new ConfigurationException("Queue section must have a 'name' element.");
            }
        }

        public String formatToString() {
            return "Name:" + this.getName();
        }
    }
}

