/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.ArrayList;
import org.apache.qpid.AMQException;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandCompletionCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFSchemaResponseCommand;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFSchemaRequestCommand
extends QMFCommand {
    private final String _packageName;
    private final String _className;
    private final byte[] _hash;

    public QMFSchemaRequestCommand(QMFCommandHeader header, BBDecoder decoder) {
        super(header);
        this._packageName = decoder.readStr8();
        this._className = decoder.readStr8();
        this._hash = decoder.readBin128();
    }

    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String routingKey = message.getMessageHeader().getReplyToRoutingKey();
        IApplicationRegistry appRegistry = virtualHost.getApplicationRegistry();
        QMFService service = appRegistry.getQMFService();
        QMFPackage qmfPackage = service.getPackage(this._packageName);
        QMFClass qmfClass = qmfPackage.getQMFClass(this._className);
        QMFCommand[] commands = new QMFCommand[]{new QMFSchemaResponseCommand(this, qmfClass), new QMFCommandCompletionCommand(this)};
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(routingKey, cmd);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

