/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.qpid.AMQException;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFClassIndicationCommand;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandCompletionCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFClassQueryCommand
extends QMFCommand {
    private final String _package;

    public QMFClassQueryCommand(QMFCommandHeader header, BBDecoder decoder) {
        super(header);
        this._package = decoder.readStr8();
    }

    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String routingKey = message.getMessageHeader().getReplyToRoutingKey();
        IApplicationRegistry appRegistry = virtualHost.getApplicationRegistry();
        QMFService service = appRegistry.getQMFService();
        QMFPackage qmfPackage = service.getPackage(this._package);
        Collection<QMFClass> qmfClasses = qmfPackage.getClasses();
        QMFCommand[] commands = new QMFCommand[qmfClasses.size() + 1];
        int i = 0;
        for (QMFClass qmfClass : qmfClasses) {
            commands[i++] = new QMFClassIndicationCommand(this, qmfClass);
        }
        commands[commands.length - 1] = new QMFCommandCompletionCommand(this);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(routingKey, cmd);
            Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

