/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.mbeans;

import java.io.IOException;
import org.apache.qpid.management.common.mbeans.annotations.MBeanAttribute;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;

public interface ServerInformation {
    public static final String TYPE = "ServerInformation";
    public static final int QPID_JMX_API_MAJOR_VERSION = 2;
    public static final int QPID_JMX_API_MINOR_VERSION = 3;

    @MBeanAttribute(name="ManagementApiMajorVersion", description="The major version number for the broker management API")
    public Integer getManagementApiMajorVersion() throws IOException;

    @MBeanAttribute(name="ManagementApiMinorVersion", description="The minor version number for the broker management API")
    public Integer getManagementApiMinorVersion() throws IOException;

    @MBeanAttribute(name="BuildVersion", description="The repository build version string")
    public String getBuildVersion() throws IOException;

    @MBeanAttribute(name="ProductVersion", description="The product version string")
    public String getProductVersion() throws IOException;

    @MBeanOperation(name="resetStatistics", description="Resets all message and data statistics for the broker", impact=1)
    public void resetStatistics() throws Exception;

    @MBeanAttribute(name="PeakMessageDeliveryRate", description="ServerInformation Peak Message Delivery Rate")
    public double getPeakMessageDeliveryRate();

    @MBeanAttribute(name="PeakDataDeliveryRate", description="ServerInformation Peak Data Delivery Rate")
    public double getPeakDataDeliveryRate();

    @MBeanAttribute(name="MessageDeliveryRate", description="ServerInformation Message Delivery Rate")
    public double getMessageDeliveryRate();

    @MBeanAttribute(name="DataDeliveryRate", description="ServerInformation Data Delivery Rate")
    public double getDataDeliveryRate();

    @MBeanAttribute(name="TotalMessagesDelivered", description="ServerInformation Total Messages Delivered")
    public long getTotalMessagesDelivered();

    @MBeanAttribute(name="TotalDataDelivered", description="ServerInformation Total Data Delivered")
    public long getTotalDataDelivered();

    @MBeanAttribute(name="PeakMessageReceiptRate", description="ServerInformation Peak Message Receipt Rate")
    public double getPeakMessageReceiptRate();

    @MBeanAttribute(name="PeakDataReceiptRate", description="ServerInformation Peak Data Receipt Rate")
    public double getPeakDataReceiptRate();

    @MBeanAttribute(name="MessageReceiptRate", description="ServerInformation Message Receipt Rate")
    public double getMessageReceiptRate();

    @MBeanAttribute(name="DataReceiptRate", description="ServerInformation Data Receipt Rate")
    public double getDataReceiptRate();

    @MBeanAttribute(name="TotalMessagesReceived", description="ServerInformation Total Messages Received")
    public long getTotalMessagesReceived();

    @MBeanAttribute(name="TotalDataReceived", description="ServerInformation Total Data Received")
    public long getTotalDataReceived();

    @MBeanAttribute(name="StatisticsEnabled", description="ServerInformation Statistics Enabled")
    public boolean isStatisticsEnabled();
}

