/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.messaging.address;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.messaging.address.Link;
import org.apache.qpid.client.messaging.address.Node;
import org.apache.qpid.configuration.Accessor;
import org.apache.qpid.messaging.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressHelper {
    public static final String NODE = "node";
    public static final String LINK = "link";
    public static final String X_DECLARE = "x-declare";
    public static final String X_BINDINGS = "x-bindings";
    public static final String X_SUBSCRIBE = "x-subscribes";
    public static final String CREATE = "create";
    public static final String ASSERT = "assert";
    public static final String DELETE = "delete";
    public static final String FILTER = "filter";
    public static final String NO_LOCAL = "no-local";
    public static final String DURABLE = "durable";
    public static final String EXCLUSIVE = "exclusive";
    public static final String AUTO_DELETE = "auto-delete";
    public static final String TYPE = "type";
    public static final String ALT_EXCHANGE = "alternate-exchange";
    public static final String BINDINGS = "bindings";
    public static final String BROWSE = "browse";
    public static final String MODE = "mode";
    public static final String CAPACITY = "capacity";
    public static final String CAPACITY_SOURCE = "source";
    public static final String CAPACITY_TARGET = "target";
    public static final String NAME = "name";
    public static final String EXCHANGE = "exchange";
    public static final String QUEUE = "queue";
    public static final String KEY = "key";
    public static final String ARGUMENTS = "arguments";
    public static final String RELIABILITY = "reliability";
    private Address address;
    private Accessor addressProps;
    private Accessor nodeProps;
    private Accessor linkProps;

    public AddressHelper(Address address) {
        Map link_props;
        Map node_props;
        this.address = address;
        this.addressProps = new Accessor.MapAccessor(address.getOptions());
        Map map = node_props = address.getOptions() == null || address.getOptions().get(NODE) == null ? null : (Map)address.getOptions().get(NODE);
        if (node_props != null) {
            this.nodeProps = new Accessor.MapAccessor(node_props);
        }
        Map map2 = link_props = address.getOptions() == null || address.getOptions().get(LINK) == null ? null : (Map)address.getOptions().get(LINK);
        if (link_props != null) {
            this.linkProps = new Accessor.MapAccessor(link_props);
        }
    }

    public String getCreate() {
        return this.addressProps.getString(CREATE);
    }

    public String getAssert() {
        return this.addressProps.getString(ASSERT);
    }

    public String getDelete() {
        return this.addressProps.getString(DELETE);
    }

    public boolean isNoLocal() {
        Boolean b = this.nodeProps.getBoolean(NO_LOCAL);
        return b == null ? false : b;
    }

    public boolean isBrowseOnly() {
        String mode = this.addressProps.getString(MODE);
        return mode != null && mode.equals(BROWSE);
    }

    public List<AMQDestination.Binding> getBindings(Map props) {
        ArrayList<AMQDestination.Binding> bindings = new ArrayList<AMQDestination.Binding>();
        List bindingList = (List)props.get(X_BINDINGS);
        if (bindingList != null) {
            for (Map bindingMap : bindingList) {
                AMQDestination.Binding binding = new AMQDestination.Binding((String)bindingMap.get(EXCHANGE), (String)bindingMap.get(QUEUE), (String)bindingMap.get(KEY), bindingMap.get(ARGUMENTS) == null ? Collections.EMPTY_MAP : (Map)bindingMap.get(ARGUMENTS));
                bindings.add(binding);
            }
        }
        return bindings;
    }

    public Map getDeclareArgs(Map props) {
        if (props != null && props.get(X_DECLARE) != null) {
            return (Map)props.get(X_DECLARE);
        }
        return Collections.EMPTY_MAP;
    }

    public int getTargetNodeType() throws Exception {
        if (this.nodeProps == null || this.nodeProps.getString(TYPE) == null) {
            return 3;
        }
        if (this.nodeProps.getString(TYPE).equals(QUEUE)) {
            return 1;
        }
        if (this.nodeProps.getString(TYPE).equals("topic")) {
            return 2;
        }
        throw new Exception("unkown exchange type");
    }

    public Node getTargetNode(int addressType) {
        if (this.nodeProps == null || addressType == 1) {
            return new Node.ExchangeNode();
        }
        if (addressType == 2) {
            Map node = (Map)this.address.getOptions().get(NODE);
            return this.createExchangeNode(node);
        }
        return null;
    }

    private Node createExchangeNode(Map parent) {
        Map declareArgs = this.getDeclareArgs(parent);
        Accessor.MapAccessor argsMap = new Accessor.MapAccessor(declareArgs);
        Node.ExchangeNode node = new Node.ExchangeNode();
        node.setExchangeType(argsMap.getString(TYPE) == null ? null : argsMap.getString(TYPE));
        this.fillInCommonNodeArgs(node, parent, argsMap);
        return node;
    }

    private Node createQueueNode(Map parent) {
        Map declareArgs = this.getDeclareArgs(parent);
        Accessor.MapAccessor argsMap = new Accessor.MapAccessor(declareArgs);
        Node.QueueNode node = new Node.QueueNode();
        node.setAlternateExchange(argsMap.getString(ALT_EXCHANGE));
        node.setExclusive(argsMap.getBoolean(EXCLUSIVE) == null ? false : argsMap.getBoolean(EXCLUSIVE));
        this.fillInCommonNodeArgs(node, parent, argsMap);
        return node;
    }

    private void fillInCommonNodeArgs(Node node, Map parent, Accessor.MapAccessor argsMap) {
        node.setDurable(this.getDurability(parent));
        node.setAutoDelete(argsMap.getBoolean(AUTO_DELETE) == null ? false : argsMap.getBoolean(AUTO_DELETE));
        node.setAlternateExchange(argsMap.getString(ALT_EXCHANGE));
        node.setBindings(this.getBindings(parent));
        if (this.getDeclareArgs(parent).containsKey(ARGUMENTS)) {
            node.setDeclareArgs((Map)this.getDeclareArgs(parent).get(ARGUMENTS));
        }
    }

    private boolean getDurability(Map map) {
        Accessor.MapAccessor access = new Accessor.MapAccessor(map);
        Boolean result = access.getBoolean(DURABLE);
        return result == null ? false : result;
    }

    public Node getSourceNode(int addressType) {
        if (addressType == 1 && this.nodeProps != null) {
            return this.createQueueNode((Map)this.address.getOptions().get(NODE));
        }
        if (addressType == 2 && this.linkProps != null) {
            return this.createQueueNode((Map)this.address.getOptions().get(LINK));
        }
        return new Node.QueueNode();
    }

    public Link getLink() throws Exception {
        Link link = new Link();
        link.setSubscription(new Link.Subscription());
        if (this.linkProps != null) {
            link.setDurable(this.linkProps.getBoolean(DURABLE) == null ? false : this.linkProps.getBoolean(DURABLE));
            link.setName(this.linkProps.getString(NAME));
            String reliability = this.linkProps.getString(RELIABILITY);
            if (reliability != null) {
                if (reliability.equalsIgnoreCase("unreliable")) {
                    link.setReliability(Link.Reliability.UNRELIABLE);
                } else if (reliability.equalsIgnoreCase("at-least-once")) {
                    link.setReliability(Link.Reliability.AT_LEAST_ONCE);
                } else {
                    throw new Exception("The reliability mode '" + reliability + "' is not yet supported");
                }
            }
            if (((Map)this.address.getOptions().get(LINK)).get(CAPACITY) instanceof Map) {
                Accessor.MapAccessor capacityProps = new Accessor.MapAccessor((Map)((Map)this.address.getOptions().get(LINK)).get(CAPACITY));
                link.setConsumerCapacity(capacityProps.getInt(CAPACITY_SOURCE) == null ? 0 : capacityProps.getInt(CAPACITY_SOURCE));
                link.setProducerCapacity(capacityProps.getInt(CAPACITY_TARGET) == null ? 0 : capacityProps.getInt(CAPACITY_TARGET));
            } else {
                int cap = this.linkProps.getInt(CAPACITY) == null ? 0 : this.linkProps.getInt(CAPACITY);
                link.setConsumerCapacity(cap);
                link.setProducerCapacity(cap);
            }
            link.setFilter(this.linkProps.getString(FILTER));
            if (((Map)this.address.getOptions().get(LINK)).containsKey(X_SUBSCRIBE)) {
                Map x_subscribe = (Map)((Map)this.address.getOptions().get(LINK)).get(X_SUBSCRIBE);
                if (x_subscribe.containsKey(ARGUMENTS)) {
                    link.getSubscription().setArgs((Map)x_subscribe.get(ARGUMENTS));
                }
                boolean exclusive = x_subscribe.containsKey(EXCLUSIVE) ? Boolean.parseBoolean((String)x_subscribe.get(EXCLUSIVE)) : false;
                link.getSubscription().setExclusive(exclusive);
            }
        }
        return link;
    }
}

