/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractBytesMessage;

public class JMSBytesMessage
extends AbstractBytesMessage
implements BytesMessage {
    public static final String MIME_TYPE = "application/octet-stream";

    public JMSBytesMessage(AMQMessageDelegateFactory delegateFactory) {
        this(delegateFactory, null);
    }

    JMSBytesMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) {
        super(delegateFactory, data);
    }

    JMSBytesMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data);
    }

    public void reset() {
        super.reset();
        this._readableMessage = true;
    }

    protected String getMimeType() {
        return MIME_TYPE;
    }

    public long getBodyLength() throws JMSException {
        this.checkReadable();
        return this._data.limit();
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.get() != 0;
    }

    public byte readByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.get();
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.getUnsigned();
    }

    public short readShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getShort();
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getUnsignedShort();
    }

    public char readChar() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getChar();
    }

    public int readInt() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._data.getInt();
    }

    public long readLong() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._data.getLong();
    }

    public float readFloat() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._data.getFloat();
    }

    public double readDouble() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._data.getDouble();
    }

    public String readUTF() throws JMSException {
        this.checkReadable();
        try {
            short length = this.readShort();
            if (length == 0) {
                return "";
            }
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            ByteBuffer encodedString = this._data.slice();
            encodedString.limit(length);
            this._data.position(this._data.position() + length);
            CharBuffer string = decoder.decode(encodedString.buf());
            return string.toString();
        }
        catch (CharacterCodingException e) {
            JMSException jmse = new JMSException("Error decoding byte stream as a UTF8 string: " + e);
            jmse.setLinkedException((Exception)e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public int readBytes(byte[] bytes) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        this.checkReadable();
        int n = count = this._data.remaining() >= bytes.length ? bytes.length : this._data.remaining();
        if (count == 0) {
            return -1;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    public int readBytes(byte[] bytes, int maxLength) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        if (maxLength > bytes.length) {
            throw new IllegalArgumentException("maxLength must be <= bytes.length");
        }
        this.checkReadable();
        int n = count = this._data.remaining() >= maxLength ? maxLength : this._data.remaining();
        if (count == 0) {
            return -1;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    public void writeBoolean(boolean b) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.put(b ? (byte)1 : 0);
    }

    public void writeByte(byte b) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.put(b);
    }

    public void writeShort(short i) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putShort(i);
    }

    public void writeChar(char c) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putChar(c);
    }

    public void writeInt(int i) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putInt(i);
    }

    public void writeLong(long l) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putLong(l);
    }

    public void writeFloat(float v) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putFloat(v);
    }

    public void writeDouble(double v) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putDouble(v);
    }

    public void writeUTF(String string) throws JMSException {
        this.checkWritable();
        try {
            CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
            java.nio.ByteBuffer encodedString = encoder.encode(CharBuffer.wrap(string));
            this._data.putShort((short)encodedString.limit());
            this._data.put(encodedString);
            this._changedData = true;
        }
        catch (CharacterCodingException e) {
            JMSException jmse = new JMSException("Unable to encode string: " + e);
            jmse.setLinkedException((Exception)e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkWritable();
        this._data.put(bytes);
        this._changedData = true;
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.checkWritable();
        this._data.put(bytes, offset, length);
        this._changedData = true;
    }

    public void writeObject(Object object) throws JMSException {
        this.checkWritable();
        if (object == null) {
            throw new NullPointerException("Argument must not be null");
        }
        Class<?> clazz = object.getClass();
        if (clazz == Byte.class) {
            this.writeByte((Byte)object);
        } else if (clazz == Boolean.class) {
            this.writeBoolean((Boolean)object);
        } else if (clazz == byte[].class) {
            this.writeBytes((byte[])object);
        } else if (clazz == Short.class) {
            this.writeShort((Short)object);
        } else if (clazz == Character.class) {
            this.writeChar(((Character)object).charValue());
        } else if (clazz == Integer.class) {
            this.writeInt((Integer)object);
        } else if (clazz == Long.class) {
            this.writeLong((Long)object);
        } else if (clazz == Float.class) {
            this.writeFloat(((Float)object).floatValue());
        } else if (clazz == Double.class) {
            this.writeDouble((Double)object);
        } else if (clazz == String.class) {
            this.writeUTF((String)object);
        } else {
            throw new MessageFormatException("Only primitives plus byte arrays and String are valid types");
        }
    }
}

