/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.transport.MessageTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToyExchange {
    static final String DIRECT = "amq.direct";
    static final String TOPIC = "amq.topic";
    private Map<String, List<LinkedBlockingQueue<MessageTransfer>>> directEx = new HashMap<String, List<LinkedBlockingQueue<MessageTransfer>>>();
    private Map<String, List<LinkedBlockingQueue<MessageTransfer>>> topicEx = new HashMap<String, List<LinkedBlockingQueue<MessageTransfer>>>();
    private Map<String, LinkedBlockingQueue<MessageTransfer>> queues = new HashMap<String, LinkedBlockingQueue<MessageTransfer>>();

    public void createQueue(String name) {
        this.queues.put(name, new LinkedBlockingQueue());
    }

    public LinkedBlockingQueue<MessageTransfer> getQueue(String name) {
        return this.queues.get(name);
    }

    public void bindQueue(String type, String binding, String queueName) {
        LinkedBlockingQueue<MessageTransfer> queue = this.queues.get(queueName);
        binding = this.normalizeKey(binding);
        if (DIRECT.equals(type)) {
            if (this.directEx.containsKey(binding)) {
                List<LinkedBlockingQueue<MessageTransfer>> list = this.directEx.get(binding);
                list.add(queue);
            } else {
                LinkedList<LinkedBlockingQueue<MessageTransfer>> list = new LinkedList<LinkedBlockingQueue<MessageTransfer>>();
                list.add(queue);
                this.directEx.put(binding, list);
            }
        } else if (this.topicEx.containsKey(binding)) {
            List<LinkedBlockingQueue<MessageTransfer>> list = this.topicEx.get(binding);
            list.add(queue);
        } else {
            LinkedList<LinkedBlockingQueue<MessageTransfer>> list = new LinkedList<LinkedBlockingQueue<MessageTransfer>>();
            list.add(queue);
            this.topicEx.put(binding, list);
        }
    }

    public boolean route(String dest, String routingKey, MessageTransfer msg) {
        List<LinkedBlockingQueue<MessageTransfer>> queues = DIRECT.equals(dest) ? this.directEx.get(routingKey) : this.matchWildCard(routingKey);
        if (queues != null && queues.size() > 0) {
            System.out.println("Message stored in " + queues.size() + " queues");
            this.storeMessage(msg, queues);
            return true;
        }
        System.out.println("Message unroutable " + msg);
        return false;
    }

    private String normalizeKey(String routingKey) {
        if (routingKey.indexOf(".*") > 1) {
            return routingKey.substring(0, routingKey.indexOf(".*"));
        }
        return routingKey;
    }

    private List<LinkedBlockingQueue<MessageTransfer>> matchWildCard(String routingKey) {
        ArrayList<LinkedBlockingQueue<MessageTransfer>> selected = new ArrayList<LinkedBlockingQueue<MessageTransfer>>();
        for (String key : this.topicEx.keySet()) {
            Pattern p = Pattern.compile(key);
            Matcher m = p.matcher(routingKey);
            if (!m.find()) continue;
            for (LinkedBlockingQueue<MessageTransfer> queue : this.topicEx.get(key)) {
                selected.add(queue);
            }
        }
        return selected;
    }

    private void storeMessage(MessageTransfer msg, List<LinkedBlockingQueue<MessageTransfer>> selected) {
        for (LinkedBlockingQueue<MessageTransfer> queue : selected) {
            queue.offer(msg);
        }
    }
}

