/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.qpid.commons;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.wso2.carbon.context.CarbonContext;

public class CommonsUtil {
    private static final String JMS_QUEUES = "event/queues/jms";
    private static final String TOPICS = "event/topics";
    private static final String JMS_SUBSCRIPTIONS = "jms.subscriptions";
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";

    public static String getQueueID(String queueName) {
        if (CarbonContext.getCurrentContext().getTenantId() > 0) {
            String tenantDomain = CarbonContext.getCurrentContext().getTenantDomain();
            if (queueName.startsWith(tenantDomain = tenantDomain.replace(".", "-"))) {
                queueName = queueName.substring(tenantDomain.length() + 1);
            }
        }
        if (queueName.indexOf(";") > -1) {
            queueName = queueName.substring(0, queueName.indexOf(";"));
        }
        return "event/queues/jms/" + queueName;
    }

    public static String getQueuesID() {
        return JMS_QUEUES;
    }

    public static String getTopicID(String topicName) {
        String topicID = TOPICS;
        if (!(topicName = topicName.replaceAll("\\.", "/")).startsWith("/")) {
            topicID = topicID + "/";
        }
        if (topicName.indexOf("*") > -1) {
            topicName = topicName.substring(0, topicName.indexOf("*"));
        } else if (topicName.indexOf("#") > -1) {
            topicName = topicName.substring(0, topicName.indexOf("#"));
        }
        return topicID + topicName;
    }

    public static String getSubscriptionID(String topicName, String subscriptionName) {
        return CommonsUtil.getTopicID(topicName) + "/" + JMS_SUBSCRIPTIONS + "/" + subscriptionName;
    }

    public static String getSubscriptonsID(String topicName) {
        return CommonsUtil.getTopicID(topicName) + "/" + JMS_SUBSCRIPTIONS;
    }

    public static String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        return dateFormat.format(new Date());
    }
}

