/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.admin.internal;

import java.util.List;
import java.util.UUID;
import org.apache.axis2.context.MessageContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.messagebox.MessageBoxDetails;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.MessageDetails;
import org.wso2.carbon.messagebox.PermissionLabel;
import org.wso2.carbon.messagebox.admin.internal.MessageBoxDetail;
import org.wso2.carbon.messagebox.admin.internal.SQSKeys;
import org.wso2.carbon.messagebox.admin.internal.exception.MessageBoxAdminException;
import org.wso2.carbon.messagebox.admin.internal.util.MessageBoxHolder;
import org.wso2.carbon.messagebox.internal.utils.Utils;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;

public class MessageBoxAdminService
extends AbstractAdmin {
    public MessageBoxDetail[] getAllMessageBoxes(int startingIndex, int maxMessageBoxesCount) throws MessageBoxAdminException {
        MessageBoxHolder messageBoxService = MessageBoxHolder.getInstance();
        try {
            String[] eprs = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration().getServiceForActivation("MessageQueue").getEPRs();
            MessageBoxDetails[] messageBoxDetailsArray = messageBoxService.getMessageboxService().getAllMessageBoxes();
            int resultSetSize = maxMessageBoxesCount;
            if (messageBoxDetailsArray.length - startingIndex < maxMessageBoxesCount) {
                resultSetSize = messageBoxDetailsArray.length - startingIndex;
            }
            MessageBoxDetail[] messageBoxDetailArray = new MessageBoxDetail[resultSetSize];
            int index = 0;
            int messageBoxDetailsIndex = 0;
            for (MessageBoxDetails messageBoxDetails : messageBoxDetailsArray) {
                if (startingIndex == index || startingIndex < index) {
                    messageBoxDetailArray[messageBoxDetailsIndex] = new MessageBoxDetail();
                    messageBoxDetailArray[messageBoxDetailsIndex].setMessageBoxName(messageBoxDetails.getMessageBoxName());
                    messageBoxDetailArray[messageBoxDetailsIndex].setNumberOfMessages(messageBoxDetails.getNumberOfMessages());
                    messageBoxDetailArray[messageBoxDetailsIndex].setOwner(messageBoxDetails.getMessageBoxOwner());
                    messageBoxDetailArray[messageBoxDetailsIndex].setVisibilityTimeout(Long.toString(messageBoxDetails.getDefaultVisibilityTimeout()));
                    messageBoxDetailArray[messageBoxDetailsIndex].setMessageBoxId(messageBoxDetails.getMessageBoxId());
                    messageBoxDetailArray[messageBoxDetailsIndex].setTenantDomain(messageBoxDetails.getTenantDomain());
                    List sharedUsersList = messageBoxDetails.getSharedUsersList();
                    messageBoxDetailArray[messageBoxDetailsIndex].setSharedUsers(sharedUsersList.toArray(new String[sharedUsersList.size()]));
                    messageBoxDetailArray[messageBoxDetailsIndex].setEpr(eprs);
                    if (++messageBoxDetailsIndex == maxMessageBoxesCount) break;
                }
                ++index;
            }
            return messageBoxDetailArray;
        }
        catch (MessageBoxException e) {
            throw new MessageBoxAdminException("Failed to list all messageboxes.", e);
        }
    }

    public int getMessageBoxesCount() throws MessageBoxAdminException {
        MessageBoxHolder messageBoxService = MessageBoxHolder.getInstance();
        try {
            return messageBoxService.getMessageboxService().getAllMessageBoxes().length;
        }
        catch (MessageBoxException e) {
            throw new MessageBoxAdminException("Failed to get total number of message boxes.", e);
        }
    }

    public MessageDetails[] getAllAvailableMessages(String messageBoxId) throws MessageBoxAdminException {
        MessageBoxHolder messageBoxService = MessageBoxHolder.getInstance();
        try {
            return messageBoxService.getMessageboxService().getAllAvailableMessages(messageBoxId);
        }
        catch (MessageBoxException e) {
            throw new MessageBoxAdminException("Failed to receive messages from messagebox: " + messageBoxId, e);
        }
    }

    public MessageDetails[] getAllRetrievedMessages(String messageBoxId) throws MessageBoxAdminException {
        MessageBoxHolder messageBoxService = MessageBoxHolder.getInstance();
        try {
            return messageBoxService.getMessageboxService().getAllRetrievedMessages(messageBoxId);
        }
        catch (MessageBoxException e) {
            throw new MessageBoxAdminException("Failed to receive messages from messagebox: " + messageBoxId, e);
        }
    }

    public PermissionLabel[] getAllPermissions(String messageBoxId) throws MessageBoxAdminException {
        MessageBoxHolder messageBoxService = MessageBoxHolder.getInstance();
        try {
            List permissionLabels = messageBoxService.getMessageboxService().getAllPermissions(messageBoxId);
            return permissionLabels.toArray(new PermissionLabel[permissionLabels.size()]);
        }
        catch (MessageBoxException e) {
            throw new MessageBoxAdminException("Failed to receive messages from messagebox: " + messageBoxId, e);
        }
    }

    public SQSKeys getSQSKeys(String userName) throws MessageBoxAdminException {
        Registry registry = CarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
        String loggedInUser = CarbonContext.getCurrentContext().getUsername();
        String accessKeyId = null;
        String secretAccessKeyId = null;
        try {
            Collection userCollection;
            if (registry.resourceExists("/users/" + userName)) {
                userCollection = (Collection)registry.get("/users/" + userName);
                accessKeyId = userCollection.getProperty("accessKeyId");
                secretAccessKeyId = userCollection.getProperty("secretAccessKeyId");
            }
            if (accessKeyId == null || secretAccessKeyId == null || !registry.resourceExists("/users/" + userName)) {
                accessKeyId = UUID.randomUUID().toString();
                secretAccessKeyId = UUID.fromString(accessKeyId).toString().concat(UUID.randomUUID().toString()).replaceAll("-", "").substring(24);
                accessKeyId = accessKeyId.replaceAll("-", "").substring(12);
                userCollection = registry.newCollection();
                registry.put("/users/" + userName, (Resource)userCollection);
                userCollection.addProperty("accessKeyId", accessKeyId);
                userCollection.addProperty("secretAccessKeyId", secretAccessKeyId);
                registry.put("/users/" + userName, (Resource)userCollection);
                String accessKeyIndexPath = "/users/access.key.index";
                if (!registry.resourceExists(accessKeyIndexPath)) {
                    userCollection = registry.newCollection();
                    registry.put(accessKeyIndexPath, (Resource)userCollection);
                }
                userCollection = (Collection)registry.get(accessKeyIndexPath);
                userCollection.addProperty(accessKeyId, userName);
                registry.put(accessKeyIndexPath, (Resource)userCollection);
            }
            try {
                if (!loggedInUser.equals(userName) && !Utils.isAdmin((String)loggedInUser)) {
                    secretAccessKeyId = null;
                }
            }
            catch (MessageBoxException e) {
                throw new MessageBoxAdminException("Failed to check if the logged in user has admin privileges.");
            }
            return new SQSKeys(accessKeyId, secretAccessKeyId);
        }
        catch (RegistryException e) {
            throw new MessageBoxAdminException("Failed to get access keys of user " + userName, e);
        }
    }
}

